/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.widget.DelegateWidgetWithTranslate;
import org.joml.Matrix4f;

public class PaddedCenterWidget
extends DelegateWidgetWithTranslate {
    private final Rectangle bounds;

    public PaddedCenterWidget(Rectangle bounds, WidgetWithBounds widget) {
        super(widget, Matrix4f::new);
        this.bounds = bounds;
    }

    @Override
    protected Matrix4f translate() {
        Rectangle widgetBounds = ((WidgetWithBounds)this.delegate()).getBounds();
        float xTranslate = 0.0f;
        float yTranslate = 0.0f;
        if (widgetBounds.width < this.bounds.width) {
            xTranslate = (float)(this.bounds.width - widgetBounds.width) / 2.0f;
        }
        if (widgetBounds.height < this.bounds.height) {
            yTranslate = (float)(this.bounds.height - widgetBounds.height) / 2.0f;
        }
        return new Matrix4f().translate(xTranslate, yTranslate, 0.0f);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle widgetBounds = ((WidgetWithBounds)this.delegate()).getBounds();
        int newWidth = Math.max(widgetBounds.width, this.bounds.width);
        int newHeight = Math.max(widgetBounds.height, this.bounds.height);
        return new Rectangle((double)((float)this.bounds.getCenterX() - (float)newWidth / 2.0f), (double)((float)this.bounds.getCenterY() - (float)newHeight / 2.0f), (double)newWidth, (double)newHeight);
    }
}

