/*
 * Decompiled with CFR 0.152.
 */
package net.archers.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.archers.ArchersMod;
import net.archers.config.TweaksConfig;
import net.archers.item.Group;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.item.weapon.SpellWeaponItem;
import net.spell_engine.api.item.weapon.Weapon;

public class Weapons {
    public static final ArrayList<RangedEntry> rangedEntries = new ArrayList();
    public static final ArrayList<Weapon.Entry> meleeEntries = new ArrayList();
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final String AETHER = "aether";
    public static final Weapon.Entry flint_spear = Weapons.spear("flint_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8927, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8145})), 4.0f);
    public static final Weapon.Entry iron_spear = Weapons.spear("iron_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8923, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})), 5.0f);
    public static final Weapon.Entry golden_spear = Weapons.spear("golden_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8929, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})), 3.0f);
    public static final Weapon.Entry diamond_spear = Weapons.spear("diamond_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 6.0f);
    public static final Weapon.Entry netherite_spear = Weapons.spear("netherite_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 7.0f);
    private static final int durabilityTier0 = 384;
    private static final int durabilityTier1 = 465;
    private static final int durabilityTier2 = class_1834.field_8930.method_8025();
    private static final int durabilityTier3 = class_1834.field_22033.method_8025();
    private static final float pullTime_shortBow = -0.19999999f;
    private static final float pullTime_longBow = 0.5f;
    private static final float pullTime_rapidCrossbow = 0.0f;
    private static final float pullTime_heavyCrossbow = 0.75f;
    private static final float velocity_shortBow = 0.0f;
    private static final float velocity_longBow = 0.75f;
    private static final float velocity_rapidCrossbow = 0.0f;
    private static final float velocity_heavyCrossbow = 0.5f;
    public static RangedEntry composite_longbow = Weapons.bow("composite_longbow", 465, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606}), new RangedConfig(8.0f, 0.5f, 0.75f));
    public static RangedEntry mechanic_shortbow = Weapons.bow("mechanic_shortbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725}), new RangedConfig(8.0f, -0.19999999f, 0.0f));
    public static RangedEntry royal_longbow = Weapons.bow("royal_longbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695}), new RangedConfig(10.0f, 0.5f, 0.75f));
    public static RangedEntry netherite_shortbow = Weapons.bow("netherite_shortbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(9.0f, -0.19999999f, 0.0f));
    public static RangedEntry netherite_longbow = Weapons.bow("netherite_longbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(12.0f, 0.5f, 0.75f));
    public static RangedEntry rapid_crossbow = Weapons.crossbow("rapid_crossbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725}), new RangedConfig(8.5f, 0.0f, 0.0f));
    public static RangedEntry heavy_crossbow = Weapons.crossbow("heavy_crossbow", durabilityTier2, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), new RangedConfig(13.0f, 0.75f, 0.5f));
    public static RangedEntry netherite_rapid_crossbow = Weapons.crossbow("netherite_rapid_crossbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(9.5f, 0.0f, 0.0f));
    public static RangedEntry netherite_heavy_crossbow = Weapons.crossbow("netherite_heavy_crossbow", durabilityTier3, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), new RangedConfig(15.0f, 0.75f, 0.5f));

    private static Supplier<class_1856> ingredient(String idString, boolean requirement, class_1792 fallback) {
        class_2960 id = class_2960.method_60654((String)idString);
        if (requirement) {
            return () -> class_1856.method_8091((class_1935[])new class_1935[]{fallback});
        }
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    private static Weapon.Entry addMelee(String name, Weapon.CustomMaterial material, Weapon.Factory factory, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("archers", name, material, factory, defaults, null);
        meleeEntries.add(entry);
        return entry;
    }

    private static Weapon.Entry spear(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.addMelee(name, material, SpellWeaponItem::new, new ItemConfig.Weapon(damage, -2.6f));
    }

    private static RangedEntry bow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(class_2960.method_60655((String)"archers", (String)name), CustomBow::new, defaults, repairIngredientSupplier, durability);
        rangedEntries.add(entry);
        return entry;
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(class_2960.method_60655((String)"archers", (String)name), CustomCrossbow::new, defaults, repairIngredientSupplier, durability);
        rangedEntries.add(entry);
        return entry;
    }

    public static void register(Map<String, RangedConfig> rangedConfig, Map<String, ItemConfig.Weapon> meleeConfig) {
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            Supplier<class_1856> aeterniumRepair = Weapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), class_1802.field_22020);
            Supplier<class_1856> crystalRepair = Weapons.ingredient("betterend:crystal_shards", FabricLoader.getInstance().isModLoaded(BETTER_END), class_1802.field_22020);
            Weapons.spear("aeternium_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, aeterniumRepair), 8.0f);
            Weapons.bow("crystal_shortbow", durabilityTier3, crystalRepair, new RangedConfig(10.0f, -0.19999999f, 0.0f));
            Weapons.bow("crystal_longbow", durabilityTier3, crystalRepair, new RangedConfig(13.5f, 0.5f, 0.75f));
        }
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            Supplier<class_1856> rubyRepair = Weapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), class_1802.field_22020);
            Weapons.spear("ruby_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, rubyRepair), 8.0f);
            Weapons.crossbow("ruby_rapid_crossbow", durabilityTier3, rubyRepair, new RangedConfig(10.5f, 0.0f, 0.0f));
            Weapons.crossbow("ruby_heavy_crossbow", durabilityTier3, rubyRepair, new RangedConfig(17.0f, 0.75f, 0.5f));
        }
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(AETHER)) {
            Supplier<class_1856> aetherRepair = Weapons.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), class_1802.field_22020);
            Weapons.spear("aether_spear", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, aetherRepair), 8.0f);
            Weapons.bow("aether_longbow", durabilityTier3, aetherRepair, new RangedConfig(13.5f, 0.5f, 0.0f));
            Weapons.crossbow("aether_rapid_crossbow", durabilityTier3, aetherRepair, new RangedConfig(10.5f, 0.0f, 0.0f));
            Weapons.crossbow("aether_heavy_crossbow", durabilityTier3, aetherRepair, new RangedConfig(17.0f, 0.75f, 0.5f));
        }
        int netheriteTier = Tiers.unsafe((String)"netherite");
        Weapon.register(meleeConfig, meleeEntries, Group.KEY);
        for (RangedEntry entry : rangedEntries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            class_1792.class_1793 settings = new class_1792.class_1793();
            int tier = Tiers.unsafe((class_2960)entry.id());
            if (tier >= netheriteTier) {
                settings.method_24359();
            }
            class_1792 item = entry.create(settings);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (RangedEntry entry : rangedEntries) {
                content.method_45421((class_1935)entry.item);
            }
        });
    }

    public static final class RangedEntry {
        private final class_2960 id;
        private final RangedFactory factory;
        private final RangedConfig defaults;
        private final Supplier<class_1856> repairIngredientSupplier;
        private final int durability;
        public class_1792 item;

        public RangedEntry(class_2960 id, RangedFactory factory, RangedConfig defaults, Supplier<class_1856> repairIngredientSupplier, int durability) {
            this.id = id;
            this.factory = factory;
            this.defaults = defaults;
            this.repairIngredientSupplier = repairIngredientSupplier;
            this.durability = durability;
        }

        public class_2960 id() {
            return this.id;
        }

        public RangedFactory factory() {
            return this.factory;
        }

        public RangedConfig defaults() {
            return this.defaults;
        }

        public Supplier<class_1856> repairIngredientSupplier() {
            return this.repairIngredientSupplier;
        }

        public int durability() {
            return this.durability;
        }

        public class_1792 create(class_1792.class_1793 settings) {
            this.item = this.factory.create(settings.method_7895(this.durability), this.defaults, this.repairIngredientSupplier);
            return this.item;
        }

        public class_1792 item() {
            return this.item;
        }
    }

    public static interface RangedFactory {
        public class_1792 create(class_1792.class_1793 var1, RangedConfig var2, Supplier<class_1856> var3);
    }
}

