/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.pneumono.pneumonocore.datagen.AbstractConfigCondition;
import net.pneumono.pneumonocore.datagen.enums.ConditionType;

public class AndConfigCondition
extends AbstractConfigCondition {
    private final AbstractConfigCondition[] conditions;

    public AndConfigCondition(AbstractConfigCondition ... conditions) {
        super(ConditionType.AND);
        this.conditions = conditions;
    }

    @Override
    public boolean conditionFulfilled() {
        boolean fulfilled = true;
        for (AbstractConfigCondition condition : this.conditions) {
            if (condition.conditionFulfilled()) continue;
            fulfilled = false;
            break;
        }
        return fulfilled;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.getType().toString());
        JsonArray array = new JsonArray();
        for (AbstractConfigCondition condition : this.conditions) {
            array.add((JsonElement)condition.toJson());
        }
        object.add("conditions", (JsonElement)array);
        return object;
    }
}

