/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config.entries;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config.ConfigsListWidget;
import net.pneumono.pneumonocore.config.IntegerConfiguration;
import net.pneumono.pneumonocore.config.entries.AbstractConfigurationEntry;
import net.pneumono.pneumonocore.util.PneumonoMathHelper;

@Environment(value=EnvType.CLIENT)
public class IntegerConfigurationEntry
extends AbstractConfigurationEntry {
    private final ConfigSliderWidget sliderWidget;
    private int value;

    public IntegerConfigurationEntry(AbstractConfiguration<?> configuration, ConfigOptionsScreen parent, ConfigsListWidget widget) {
        super(configuration, parent, widget);
        int maxValue;
        int minValue;
        if (configuration instanceof IntegerConfiguration) {
            IntegerConfiguration integerConfiguration = (IntegerConfiguration)configuration;
            this.value = (Integer)integerConfiguration.getValue();
            minValue = integerConfiguration.getMinValue();
            maxValue = integerConfiguration.getMaxValue();
        } else {
            this.value = 0;
            minValue = 0;
            maxValue = 10;
        }
        this.sliderWidget = new ConfigSliderWidget((slider, configValue) -> {
            this.parent.selectedConfiguration = configuration;
            ConfigOptionsScreen.save(configuration.getModID(), configuration.getName(), configValue);
            this.widget.update();
        }, this.value, minValue, maxValue, 0, 0, 110, 20);
        this.sliderWidget.setValue(this.value);
        this.update();
    }

    @Override
    public void update() {
        int newValue;
        int n;
        AbstractConfiguration abstractConfiguration = this.configuration;
        if (abstractConfiguration instanceof IntegerConfiguration) {
            IntegerConfiguration integerConfiguration = (IntegerConfiguration)abstractConfiguration;
            n = (Integer)integerConfiguration.getValue();
        } else {
            n = 0;
        }
        this.value = newValue = n;
        this.sliderWidget.setValue(newValue);
    }

    @Override
    public void reset() {
        ConfigOptionsScreen.save(this.configuration.getModID(), this.configuration.getName(), this.configuration.getDefaultValue());
        this.update();
    }

    public List<? extends class_6379> method_37025() {
        return ImmutableList.of((Object)((Object)this.sliderWidget));
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)((Object)this.sliderWidget));
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.renderNameAndInformation(context, x, y, entryHeight, mouseX, mouseY, tickDelta);
        this.sliderWidget.method_46421(x + 90);
        this.sliderWidget.method_46419(y);
        this.sliderWidget.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigSliderWidget
    extends class_357 {
        private final SliderChangeAction action;
        private final int min;
        private final int max;

        public ConfigSliderWidget(SliderChangeAction action, int value, int min, int max, int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)Integer.toString(PneumonoMathHelper.round(ConfigSliderWidget.toPercentage(value, min, max)))), ConfigSliderWidget.toPercentage(value, min, max));
            this.action = action;
            this.min = min;
            this.max = max;
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)Integer.toString(ConfigSliderWidget.fromPercentage(this.field_22753, this.min, this.max))));
        }

        private static int fromPercentage(double value, int min, int max) {
            return PneumonoMathHelper.round(value * (double)(max - min) + (double)min);
        }

        private static double toPercentage(int value, int min, int max) {
            return (double)(value - min) / (double)(max - min);
        }

        protected void method_25344() {
            this.action.onChange(this, ConfigSliderWidget.fromPercentage(this.field_22753, this.min, this.max));
        }

        public void setValue(int value) {
            this.field_22753 = ConfigSliderWidget.toPercentage(class_3532.method_15340((int)value, (int)this.min, (int)this.max), this.min, this.max);
            this.method_25346();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface SliderChangeAction {
        public void onChange(ConfigSliderWidget var1, int var2);
    }
}

