/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config.entries;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config.ConfigsListWidget;
import net.pneumono.pneumonocore.config.FloatConfiguration;
import net.pneumono.pneumonocore.config.entries.AbstractConfigurationEntry;
import net.pneumono.pneumonocore.util.PneumonoMathHelper;

@Environment(value=EnvType.CLIENT)
public class FloatConfigurationEntry
extends AbstractConfigurationEntry {
    private final ConfigSliderWidget sliderWidget;
    private float value;

    public FloatConfigurationEntry(AbstractConfiguration<?> configuration, ConfigOptionsScreen parent, ConfigsListWidget widget) {
        super(configuration, parent, widget);
        float f;
        if (configuration instanceof FloatConfiguration) {
            FloatConfiguration floatConfiguration = (FloatConfiguration)configuration;
            f = ((Float)floatConfiguration.getValue()).floatValue();
        } else {
            f = 0.0f;
        }
        this.value = f;
        this.sliderWidget = new ConfigSliderWidget((slider, configValue) -> {
            this.parent.selectedConfiguration = configuration;
            ConfigOptionsScreen.save(configuration.getModID(), configuration.getName(), Float.valueOf(configValue));
            this.widget.update();
        }, this.value, 0, 0, 110, 20);
        this.sliderWidget.setValue(this.value);
        this.update();
    }

    @Override
    public void update() {
        float newValue;
        float f;
        AbstractConfiguration abstractConfiguration = this.configuration;
        if (abstractConfiguration instanceof FloatConfiguration) {
            FloatConfiguration floatConfiguration = (FloatConfiguration)abstractConfiguration;
            f = ((Float)floatConfiguration.getValue()).floatValue();
        } else {
            f = 0.0f;
        }
        this.value = newValue = f;
        this.sliderWidget.setValue(newValue);
    }

    @Override
    public void reset() {
        ConfigOptionsScreen.save(this.configuration.getModID(), this.configuration.getName(), this.configuration.getDefaultValue());
        this.update();
    }

    public List<? extends class_6379> method_37025() {
        return ImmutableList.of((Object)((Object)this.sliderWidget));
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)((Object)this.sliderWidget));
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.renderNameAndInformation(context, x, y, entryHeight, mouseX, mouseY, tickDelta);
        this.sliderWidget.method_46421(x + 90);
        this.sliderWidget.method_46419(y);
        this.sliderWidget.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigSliderWidget
    extends class_357 {
        private final SliderChangeAction action;

        public ConfigSliderWidget(SliderChangeAction action, float value, int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)Float.toString(ConfigSliderWidget.round(value))), (double)value);
            this.action = action;
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)Float.toString(ConfigSliderWidget.round(this.field_22753))));
        }

        private static float round(double value) {
            return (float)PneumonoMathHelper.round(value * 100.0) / 100.0f;
        }

        protected void method_25344() {
            this.action.onChange(this, ConfigSliderWidget.round(this.field_22753));
        }

        public void setValue(float value) {
            this.field_22753 = value;
            this.method_25346();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface SliderChangeAction {
        public void onChange(ConfigSliderWidget var1, float var2);
    }
}

