/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

public enum TimeUnit {
    TICKS(1),
    SECONDS(20),
    MINUTES(1200),
    HOURS(72000),
    DAYS(1728000);

    private final int division;

    private TimeUnit(int division) {
        this.division = division;
    }

    public int getDivision() {
        return this.division;
    }

    public static TimeUnit fromValue(long value) {
        if (value == 0L) {
            return TICKS;
        }
        if (value % (long)TimeUnit.DAYS.division == 0L) {
            return DAYS;
        }
        if (value % (long)TimeUnit.HOURS.division == 0L) {
            return HOURS;
        }
        if (value % (long)TimeUnit.MINUTES.division == 0L) {
            return MINUTES;
        }
        if (value % (long)TimeUnit.SECONDS.division == 0L) {
            return SECONDS;
        }
        return TICKS;
    }
}

