/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.ModConfigurations;

public class PackagedConfigs {
    private final Set<AbstractConfiguration<?>> configs;

    public PackagedConfigs() {
        Configs.LOGGER.info("Creating new config sync packet");
        ArrayList packagedConfigs = new ArrayList();
        for (ModConfigurations modConfigs : Configs.CONFIGS.values()) {
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (config.isClientSide()) continue;
                packagedConfigs.add(config);
            }
        }
        this.configs = Set.copyOf(packagedConfigs);
    }

    public PackagedConfigs(class_2487 compound) {
        Configs.LOGGER.info("Received config sync packet");
        this.configs = new HashSet();
        if (compound != null) {
            for (ModConfigurations modConfigs : Configs.CONFIGS.values()) {
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (compound.method_10580(config.getName()) == null) continue;
                    class_2520 element = compound.method_10580(config.getName());
                    this.configs.add(config.fromElement(element));
                }
            }
        }
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        for (AbstractConfiguration<?> config : this.configs) {
            compound.method_10582(config.getName(), config.valueToJson(false));
        }
        return compound;
    }

    public void updateServerConfigs() {
        for (ModConfigurations modConfigurations : Configs.CONFIGS.values()) {
            for (AbstractConfiguration<?> config : modConfigurations.configurations) {
                config.getReloadableLoadedValue(false);
            }
        }
        block2: for (AbstractConfiguration abstractConfiguration : this.configs) {
            ModConfigurations modConfigs = Configs.CONFIGS.get(abstractConfiguration.modID);
            if (modConfigs != null) {
                for (AbstractConfiguration<?> config : modConfigs.configurations) {
                    if (!Objects.equals(config.name, abstractConfiguration.name) || config.isClientSide()) continue;
                    config.setImportedValue(abstractConfiguration);
                    continue block2;
                }
            }
            Configs.LOGGER.warn("Received config " + abstractConfiguration.modID + ":" + abstractConfiguration.name + " which does not exist!");
        }
    }
}

