/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import com.google.gson.JsonElement;
import net.minecraft.class_2520;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ConfigEnv;

public class EnumConfiguration<T extends Enum<T>>
extends AbstractConfiguration<T> {
    private final Class<T> enumClass;

    public EnumConfiguration(String modID, String name, ConfigEnv environment, T defaultValue) {
        super(modID, name, environment, defaultValue);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
    }

    private EnumConfiguration(String modID, String name, ConfigEnv environment, T defaultValue, T loadedValue) {
        super(modID, name, environment, defaultValue, loadedValue);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
    }

    @Override
    public EnumConfiguration<T> fromElement(class_2520 element) {
        return new EnumConfiguration<Enum>(this.modID, this.name, this.environment, (Enum)this.getDefaultValue(), (Enum)this.getEnumFromString(element.method_10714()));
    }

    @Override
    protected EnumConfiguration<T> fromElement(JsonElement element) {
        return new EnumConfiguration<Enum>(this.modID, this.name, this.environment, (Enum)this.getDefaultValue(), (Enum)this.getEnumFromString(element.getAsString()));
    }

    private T getEnumFromString(String string) {
        for (Enum type : (Enum[])this.enumClass.getEnumConstants()) {
            if (!type.name().equalsIgnoreCase(string)) continue;
            return (T)type;
        }
        return (T)((Enum)this.getDefaultValue());
    }

    @Override
    public String getClassID() {
        return "EnumConfiguration";
    }
}

