/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.ConfigPayload;
import net.pneumono.pneumonocore.config.ModConfigurations;
import net.pneumono.pneumonocore.config.PackagedConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configs {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PneumonoCoreConfig");
    protected static Map<String, ModConfigurations> CONFIGS = new HashMap<String, ModConfigurations>();

    public static <T extends AbstractConfiguration<?>> T register(T configuration) {
        if (!Configs.isValid(configuration)) {
            LOGGER.error("Configuration " + configuration.modID + ":" + configuration.name + " was not registered successfully!");
            return configuration;
        }
        boolean modConfigExists = false;
        ModConfigurations modConfigs = CONFIGS.get(configuration.modID);
        if (modConfigs != null) {
            boolean isDuplicate = false;
            for (AbstractConfiguration<?> checkedConfiguration : modConfigs.configurations) {
                if (!Objects.equals(checkedConfiguration.name, configuration.name)) continue;
                isDuplicate = true;
                break;
            }
            if (!isDuplicate) {
                modConfigs.configurations.add(configuration);
                modConfigExists = true;
            } else {
                LOGGER.error("Configuration " + configuration.modID + ":" + configuration.name + " is a duplicate, and so was not registered!");
            }
        }
        if (!modConfigExists) {
            CONFIGS.put(configuration.getModID(), new ModConfigurations(configuration.getModID(), configuration));
        }
        configuration.registered = true;
        return configuration;
    }

    public static void reload(String modID) {
        ModConfigurations modConfigs = CONFIGS.get(modID);
        if (modConfigs != null) {
            modConfigs.reload();
        }
    }

    public static void sendS2CConfigSyncPacket(List<class_3222> players) {
        class_2487 compound = new PackagedConfigs().toNbt();
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigPayload(compound));
        }
    }

    protected static void sendS2CConfigSyncPacket(class_3222 ... players) {
        Configs.sendS2CConfigSyncPacket(List.of(players));
    }

    private static boolean isValid(AbstractConfiguration<?> configuration) {
        return configuration.getName() != null && !Objects.equals(configuration.getName(), "") && configuration.getModID() != null && !Objects.equals(configuration.getModID(), "");
    }

    public static boolean hasConfigs(String modID) {
        ModConfigurations modConfigs = CONFIGS.get(modID);
        if (modConfigs != null) {
            return !modConfigs.configurations.isEmpty();
        }
        return false;
    }

    public static AbstractConfiguration<?> getConfig(String modID, String name) {
        ModConfigurations modConfigs = CONFIGS.get(modID);
        if (modConfigs != null) {
            for (AbstractConfiguration<?> config : modConfigs.configurations) {
                if (!Objects.equals(config.name, name)) continue;
                return config;
            }
        }
        LOGGER.warn("Requested config " + modID + ":" + name + ", which does not exist!");
        return null;
    }
}

