/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.lists;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateType;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;

public class VisibleChunkCollector
implements OcclusionCuller.Visitor {
    private final ObjectArrayList<ChunkRenderList> sortedRenderLists;
    private final EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>> sortedRebuildLists;
    private final int frame;
    private static int[] sortItems = new int[256];

    public VisibleChunkCollector(int frame) {
        this.frame = frame;
        this.sortedRenderLists = new ObjectArrayList();
        this.sortedRebuildLists = new EnumMap(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.sortedRebuildLists.put(type, new ArrayDeque());
        }
    }

    @Override
    public void visit(RenderSection section) {
        if (section.getFlags() != 0) {
            RenderRegion region = section.getRegion();
            ChunkRenderList renderList = region.getRenderList();
            if (renderList.getLastVisibleFrame() != this.frame) {
                renderList.reset(this.frame);
                this.sortedRenderLists.add((Object)renderList);
            }
            renderList.add(section);
        }
        this.addToRebuildLists(section);
    }

    private void addToRebuildLists(RenderSection section) {
        Queue queue;
        ChunkUpdateType type = section.getPendingUpdate();
        if (type != null && section.getTaskCancellationToken() == null && (queue = (Queue)this.sortedRebuildLists.get((Object)type)).size() < type.getMaximumQueueSize()) {
            queue.add(section);
        }
    }

    public SortedRenderLists createRenderLists(Viewport viewport) {
        CameraTransform transform = viewport.getTransform();
        int cameraX = transform.intX >> 4 + RenderRegion.REGION_WIDTH_SH;
        int cameraY = transform.intY >> 4 + RenderRegion.REGION_HEIGHT_SH;
        int cameraZ = transform.intZ >> 4 + RenderRegion.REGION_LENGTH_SH;
        int size = this.sortedRenderLists.size();
        if (sortItems.length < size) {
            sortItems = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            RenderRegion region = ((ChunkRenderList)this.sortedRenderLists.get(i)).getRegion();
            int x = Math.abs(region.getX() - cameraX);
            int y = Math.abs(region.getY() - cameraY);
            int z = Math.abs(region.getZ() - cameraZ);
            VisibleChunkCollector.sortItems[i] = x + y + z << 16 | i;
        }
        IntArrays.unstableSort((int[])sortItems, (int)0, (int)size);
        ObjectArrayList sorted = new ObjectArrayList(size);
        for (int i = 0; i < size; ++i) {
            int key = sortItems[i];
            ChunkRenderList renderList = (ChunkRenderList)this.sortedRenderLists.get(key & 0xFFFF);
            sorted.add((Object)renderList);
        }
        for (ChunkRenderList list : sorted) {
            list.sortSections(transform, sortItems);
        }
        return new SortedRenderLists((ObjectArrayList<ChunkRenderList>)sorted);
    }

    public Map<ChunkUpdateType, ArrayDeque<RenderSection>> getRebuildLists() {
        return this.sortedRebuildLists;
    }
}

