/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.render;

import mod.azure.azurelibarmor.rewrite.model.AzBakedModel;
import mod.azure.azurelibarmor.rewrite.render.AzLayerRenderer;
import mod.azure.azurelibarmor.rewrite.render.AzModelRenderer;
import mod.azure.azurelibarmor.rewrite.render.AzPhasedRenderer;
import mod.azure.azurelibarmor.rewrite.render.AzRendererConfig;
import mod.azure.azurelibarmor.rewrite.render.AzRendererPipelineContext;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public abstract class AzRendererPipeline<T>
implements AzPhasedRenderer<T> {
    protected final AzRendererConfig<T> config;
    private final AzRendererPipelineContext<T> context;
    private final AzLayerRenderer<T> layerRenderer;
    private final AzModelRenderer<T> modelRenderer;

    protected AzRendererPipeline(AzRendererConfig<T> config) {
        this.config = config;
        this.context = this.createContext(this);
        this.layerRenderer = this.createLayerRenderer(config);
        this.modelRenderer = this.createModelRenderer(this.layerRenderer);
    }

    protected abstract AzRendererPipelineContext<T> createContext(AzRendererPipeline<T> var1);

    protected abstract AzModelRenderer<T> createModelRenderer(AzLayerRenderer<T> var1);

    protected abstract AzLayerRenderer<T> createLayerRenderer(AzRendererConfig<T> var1);

    protected abstract void updateAnimatedTextureFrame(T var1);

    public void render(class_4587 poseStack, AzBakedModel model, T animatable, class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_4588 buffer, float yaw, float partialTick, int packedLight) {
        renderType = this.config.getRenderType(animatable);
        this.context.populate(animatable, model, bufferSource, packedLight, partialTick, poseStack, renderType, buffer);
        poseStack.method_22903();
        this.preRender(this.context, false);
        this.layerRenderer.preApplyRenderLayers(this.context);
        this.modelRenderer.render(this.context, false);
        this.layerRenderer.applyRenderLayers(this.context);
        this.postRender(this.context, false);
        poseStack.method_22909();
        this.renderFinal(this.context);
        this.doPostRenderCleanup();
    }

    public void reRender(AzRendererPipelineContext<T> context) {
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        this.preRender(context, true);
        this.modelRenderer.render(context, true);
        this.postRender(context, true);
        poseStack.method_22909();
    }

    protected void renderFinal(AzRendererPipelineContext<T> context) {
    }

    protected void doPostRenderCleanup() {
    }

    protected void scaleModelForRender(AzRendererPipelineContext<T> context, float widthScale, float heightScale, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            class_4587 poseStack = context.poseStack();
            poseStack.method_22905(widthScale, heightScale, widthScale);
        }
    }

    public AzRendererConfig<T> config() {
        return this.config;
    }

    public AzRendererPipelineContext<T> context() {
        return this.context;
    }
}

