/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.render;

import mod.azure.azurelibarmor.common.internal.client.util.RenderUtils;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelibarmor.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelibarmor.rewrite.model.AzBakedModel;
import mod.azure.azurelibarmor.rewrite.model.AzBone;
import mod.azure.azurelibarmor.rewrite.render.AzLayerRenderer;
import mod.azure.azurelibarmor.rewrite.render.AzRendererPipeline;
import mod.azure.azurelibarmor.rewrite.render.AzRendererPipelineContext;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final Vector3f normalCache = new Vector3f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;
    private final Vector4f poseStateTransformCache = new Vector4f();

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        class_4587 poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(context, cube);
            poseStack.method_22909();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        class_4587 poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = this.poseStateCache.set((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            this.normalCache.set((Vector3fc)quad.normal());
            Vector3f normal = normalisedPoseState.transform(this.normalCache);
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        class_4588 buffer = context.vertexConsumer();
        int color = context.renderColor();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            this.poseStateTransformCache.set(position.x(), position.y(), position.z(), 1.0f);
            Vector4f vector4f = poseState.transform(this.poseStateTransformCache);
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), color, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }
}

