/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.property;

import java.util.Objects;
import mod.azure.azurelibarmor.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelibarmor.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelibarmor.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelibarmor.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelibarmor.rewrite.animation.property.AzAnimationProperties;
import mod.azure.azurelibarmor.rewrite.animation.property.codec.AzAnimationStagePropertiesCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzAnimationStageProperties
extends AzAnimationProperties {
    public static final AzAnimationStagePropertiesCodec CODEC = new AzAnimationStagePropertiesCodec();
    public static final AzAnimationStageProperties DEFAULT = new AzAnimationStageProperties(1.0, AzEasingTypes.NONE, AzPlayBehaviors.PLAY_ONCE, Float.valueOf(0.0f));
    public static final AzAnimationStageProperties EMPTY = new AzAnimationStageProperties(null, null, null, null);
    private final AzPlayBehavior playBehavior;

    public AzAnimationStageProperties(@Nullable Double animationSpeed, @Nullable AzEasingType easingType, @Nullable AzPlayBehavior playBehavior, @Nullable Float transitionLength) {
        super(animationSpeed, easingType, transitionLength);
        this.playBehavior = playBehavior;
    }

    public boolean hasPlayBehavior() {
        return this.playBehavior != null;
    }

    @Override
    public AzAnimationStageProperties withAnimationSpeed(double animationSpeed) {
        return new AzAnimationStageProperties(animationSpeed, this.easingType, this.playBehavior, this.transitionLength);
    }

    @Override
    public AzAnimationStageProperties withEasingType(@NotNull AzEasingType easingType) {
        return new AzAnimationStageProperties(this.animationSpeed, easingType, this.playBehavior, this.transitionLength);
    }

    public AzAnimationStageProperties withPlayBehavior(@NotNull AzPlayBehavior playBehavior) {
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, playBehavior, this.transitionLength);
    }

    @Override
    public AzAnimationStageProperties withTransitionLength(float transitionLength) {
        return new AzAnimationStageProperties(this.animationSpeed, this.easingType, this.playBehavior, Float.valueOf(transitionLength));
    }

    public AzPlayBehavior playBehavior() {
        return this.playBehavior == null ? DEFAULT.playBehavior() : this.playBehavior;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AzAnimationStageProperties that = (AzAnimationStageProperties)object;
        return Objects.equals(this.playBehavior, that.playBehavior) && super.equals(object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.playBehavior);
    }
}

