/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation;

import java.util.Map;
import mod.azure.azurelibarmor.core.utils.Interpolations;
import mod.azure.azurelibarmor.rewrite.model.AzBone;
import mod.azure.azurelibarmor.rewrite.model.AzBoneSnapshot;

public class AzCachedBoneUpdateUtil {
    public static void updateCachedBonePosition(AzBone bone, Map<String, AzBoneSnapshot> boneSnapshots, double animTime, double resetTickLength) {
        if (bone.hasPositionChanged()) {
            return;
        }
        AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
        AzBoneSnapshot saveSnapshot = boneSnapshots.get(bone.getName());
        if (saveSnapshot.isPosAnimInProgress()) {
            saveSnapshot.stopPosAnim(animTime);
        }
        double percentageReset = Math.min((animTime - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
        bone.setPosX((float)Interpolations.lerp((double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX(), percentageReset));
        bone.setPosY((float)Interpolations.lerp((double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY(), percentageReset));
        bone.setPosZ((float)Interpolations.lerp((double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ(), percentageReset));
        if (percentageReset >= 1.0) {
            saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
        }
    }

    public static void updateCachedBoneRotation(AzBone bone, Map<String, AzBoneSnapshot> boneSnapshots, double animTime, double resetTickLength) {
        if (bone.hasRotationChanged()) {
            return;
        }
        AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
        AzBoneSnapshot saveSnapshot = boneSnapshots.get(bone.getName());
        if (saveSnapshot.isRotAnimInProgress()) {
            saveSnapshot.stopRotAnim(animTime);
        }
        double percentageReset = Math.min((animTime - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
        bone.setRotX((float)Interpolations.lerp((double)saveSnapshot.getRotX(), (double)initialSnapshot.getRotX(), percentageReset));
        bone.setRotY((float)Interpolations.lerp((double)saveSnapshot.getRotY(), (double)initialSnapshot.getRotY(), percentageReset));
        bone.setRotZ((float)Interpolations.lerp((double)saveSnapshot.getRotZ(), (double)initialSnapshot.getRotZ(), percentageReset));
        if (percentageReset >= 1.0) {
            saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
        }
    }

    public static void updateCachedBoneScale(AzBone bone, Map<String, AzBoneSnapshot> boneSnapshots, double animTime, double resetTickLength) {
        if (bone.hasScaleChanged()) {
            return;
        }
        AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
        AzBoneSnapshot saveSnapshot = boneSnapshots.get(bone.getName());
        if (saveSnapshot.isScaleAnimInProgress()) {
            saveSnapshot.stopScaleAnim(animTime);
        }
        double percentageReset = Math.min((animTime - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
        bone.setScaleX((float)Interpolations.lerp((double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX(), percentageReset));
        bone.setScaleY((float)Interpolations.lerp((double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY(), percentageReset));
        bone.setScaleZ((float)Interpolations.lerp((double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ(), percentageReset));
        if (percentageReset >= 1.0) {
            saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
    }
}

