/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.internal.common.cache.texture.util;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import mod.azure.azurelibarmor.common.internal.common.AzureLib;
import mod.azure.azurelibarmor.common.internal.common.cache.texture.util.Frame;
import mod.azure.azurelibarmor.common.internal.common.cache.texture.util.Texture;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7771;

public class AnimationContents {
    public final class_7771 frameSize;
    public final Texture animatedTexture;
    private int getID;
    private class_2960 location;

    public AnimationContents(class_1011 image, class_1079 animMeta, int getID, class_2960 location) {
        this.frameSize = animMeta.method_24143(image.method_4307(), image.method_4323());
        this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        this.getID = getID;
        this.location = location;
    }

    public boolean isValid() {
        return this.animatedTexture != null;
    }

    private Texture generateAnimatedTexture(class_1011 image, class_1079 animMeta) {
        if (!class_3532.method_48117((int)image.method_4307(), (int)this.frameSize.comp_1049()) || !class_3532.method_48117((int)image.method_4323(), (int)this.frameSize.comp_1050())) {
            AzureLib.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)this.location, (Object)image.method_4307(), (Object)image.method_4323(), (Object)this.frameSize.comp_1049(), (Object)this.frameSize.comp_1050());
            return null;
        }
        int columns = image.method_4307() / this.frameSize.comp_1049();
        int rows = image.method_4323() / this.frameSize.comp_1050();
        int frameCount = columns * rows;
        ObjectArrayList frames = new ObjectArrayList();
        animMeta.method_33460((arg_0, arg_1) -> AnimationContents.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
        if (frames.isEmpty()) {
            for (int frame = 0; frame < frameCount; ++frame) {
                frames.add(new Frame(frame, animMeta.method_4684()));
            }
        } else {
            int index = 0;
            IntOpenHashSet unusedFrames = new IntOpenHashSet();
            for (Frame frame : frames) {
                if (frame.time() <= 0) {
                    AzureLib.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)this.location, (Object)index, (Object)frame.time());
                    unusedFrames.add(frame.index());
                } else if (frame.index() < 0 || frame.index() >= frameCount) {
                    AzureLib.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)this.location, (Object)index, (Object)frame.index());
                    unusedFrames.add(frame.index());
                }
                ++index;
            }
            if (!unusedFrames.isEmpty()) {
                AzureLib.LOGGER.warn("Unused frames in sprite {}: {}", (Object)this.location, (Object)Arrays.toString(unusedFrames.toArray()));
            }
        }
        return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.method_4685(), this.frameSize, this.getID);
    }

    private static /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
        frames.add(new Frame(frame, frameTime));
    }
}

