/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.internal.common.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelibarmor.common.internal.common.AzureLib;
import mod.azure.azurelibarmor.common.internal.common.AzureLibException;
import mod.azure.azurelibarmor.common.internal.common.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.common.internal.common.loading.FileLoader;
import mod.azure.azurelibarmor.common.internal.common.loading.json.raw.Model;
import mod.azure.azurelibarmor.common.internal.common.loading.object.BakedAnimations;
import mod.azure.azurelibarmor.common.internal.common.loading.object.BakedModelFactory;
import mod.azure.azurelibarmor.common.internal.common.loading.object.GeometryTree;
import mod.azure.azurelibarmor.rewrite.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelibarmor.rewrite.model.cache.AzBakedModelCache;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;

public final class AzureLibCache {
    private static final Set<String> EXCLUDED_NAMESPACES = ObjectOpenHashSet.of((Object[])new String[]{"moreplayermodels", "customnpcs", "creeperoverhaul", "geckolib", "gunsrpg", "born_in_chaos_v1", "neoforge"});
    private static Map<class_2960, BakedAnimations> ANIMATIONS = Collections.emptyMap();
    private static Map<class_2960, BakedGeoModel> MODELS = Collections.emptyMap();

    private AzureLibCache() {
        throw new UnsupportedOperationException();
    }

    public static Map<class_2960, BakedAnimations> getBakedAnimations() {
        if (!AzureLib.hasInitialized) {
            throw new AzureLibException("azurelibarmor was never initialized! Please read the documentation!");
        }
        return ANIMATIONS;
    }

    public static Map<class_2960, BakedGeoModel> getBakedModels() {
        if (!AzureLib.hasInitialized) {
            throw new AzureLibException("azurelibarmor was never initialized! Please read the documentation!");
        }
        return MODELS;
    }

    public static void registerReloadListener() {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_3300 class_33002 = mc.method_1478();
        if (!(class_33002 instanceof class_3304)) {
            throw new AzureLibException("azurelibarmor was initialized too early!");
        }
        class_3304 resourceManager = (class_3304)class_33002;
        resourceManager.method_14477(AzureLibCache::reload);
    }

    public static CompletableFuture<Void> reload(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap models = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[4];
        completableFutureArray[0] = AzureLibCache.loadAnimations(backgroundExecutor, resourceManager, ((Map)animations)::put);
        completableFutureArray[1] = AzureLibCache.loadModels(backgroundExecutor, resourceManager, ((Map)models)::put);
        completableFutureArray[2] = AzBakedAnimationCache.getInstance().loadAnimations(backgroundExecutor, resourceManager);
        completableFutureArray[3] = AzBakedModelCache.getInstance().loadModels(backgroundExecutor, resourceManager);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(arg_0 -> AzureLibCache.lambda$reload$0((Map)animations, (Map)models, arg_0), gameExecutor);
    }

    private static CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, class_3300 resourceManager, BiConsumer<class_2960, BakedAnimations> elementConsumer) {
        return AzureLibCache.loadResources(backgroundExecutor, resourceManager, "animations", resource -> FileLoader.loadAnimationsFile(resource, resourceManager), elementConsumer);
    }

    private static CompletableFuture<Void> loadModels(Executor backgroundExecutor, class_3300 resourceManager, BiConsumer<class_2960, BakedGeoModel> elementConsumer) {
        return AzureLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            Model model = FileLoader.loadModelFile(resource, resourceManager);
            return BakedModelFactory.getForNamespace(resource.method_12836()).constructGeoModel(GeometryTree.fromModel(model));
        }, elementConsumer);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, class_3300 resourceManager, String type, Function<class_2960, T> loader, BiConsumer<class_2960, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.method_14488(type, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (class_2960 resource : resources.keySet()) {
                tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((class_2960)entry.getKey()).method_12836().toLowerCase(Locale.ROOT))) continue;
                map.accept((class_2960)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }

    private static /* synthetic */ void lambda$reload$0(Map animations, Map models, Void empty) {
        ANIMATIONS = animations;
        MODELS = models;
    }
}

