/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_5244;

public class Slider<N extends Number>
extends class_357 {
    protected final class_2561 title;
    protected final N minValue;
    protected final N maxValue;
    protected final SliderValueChanged<N> onChange;

    public Slider(int x, int y, int width, int height, N minValue, N maxValue, N initialValue, SliderValueChanged<N> onChange) {
        this(x, y, width, height, null, minValue, maxValue, initialValue, onChange);
    }

    public Slider(int x, int y, int width, int height, class_2561 title, N minValue, N maxValue, N initialValue, SliderValueChanged<N> onChange) {
        super(x, y, width, height, class_5244.field_39003, (((Number)initialValue).doubleValue() - ((Number)minValue).doubleValue()) / (((Number)maxValue).doubleValue() - ((Number)minValue).doubleValue()));
        this.title = title;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.onChange = onChange;
        this.method_25346();
    }

    public N currentValue() {
        Double res = this.field_22753 * (((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue()) + ((Number)this.minValue).doubleValue();
        if (this.minValue instanceof Integer) {
            return (N)Integer.valueOf(res.intValue());
        }
        if (this.minValue instanceof Byte) {
            return (N)Byte.valueOf(res.byteValue());
        }
        if (this.minValue instanceof Short) {
            return (N)Short.valueOf(res.shortValue());
        }
        if (this.minValue instanceof Long) {
            return (N)Long.valueOf(res.longValue());
        }
        if (this.minValue instanceof Float) {
            return (N)Float.valueOf(res.floatValue());
        }
        if (this.minValue instanceof Double) {
            return (N)res;
        }
        throw new IllegalStateException("The Type " + this.minValue.getClass().getSimpleName() + " is not nativley supported. Please override currentValue with an implementation ofr that type");
    }

    protected String valueToString(N value) {
        if (this.minValue instanceof Float || this.minValue instanceof Double) {
            double v = ((Number)value).doubleValue();
            double m = ((Number)this.maxValue).doubleValue();
            if (m > 1000.0) {
                return "" + (int)v;
            }
            if (m > 100.0) {
                return String.format("%.1f", v);
            }
            if (m > 10.0) {
                return String.format("%.2f", v);
            }
            return String.format("%.4f", v);
        }
        return String.valueOf(value);
    }

    public class_2561 getValueComponent(N value) {
        return class_2561.method_43470((String)this.valueToString(value));
    }

    protected void method_25346() {
        class_2561 valueComponent = this.getValueComponent(this.currentValue());
        this.method_25355((class_2561)(this.title == null ? valueComponent : this.title.method_27661().method_27693(": ").method_10852(valueComponent)));
    }

    protected void method_25344() {
        this.onChange.now(this, this.currentValue());
    }

    @FunctionalInterface
    public static interface SliderValueChanged<N extends Number> {
        public void now(Slider<N> var1, N var2);
    }
}

