/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import de.ambertation.wunderlib.configs.AbstractConfig;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.Checkbox;
import de.ambertation.wunderlib.ui.layout.components.Container;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.MultiLineText;
import de.ambertation.wunderlib.ui.layout.components.Range;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreenWithIcon;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends LayoutScreenWithIcon {
    protected final List<AbstractConfig<?>> configFiles;
    protected final List<OnCheckboxChangeEvent> checkboxListeners;

    public ConfigScreen(class_2561 component, class_2960 icon, List<AbstractConfig<?>> configs) {
        this(EMPTY_SCREEN, icon, component, configs);
    }

    public ConfigScreen(@Nullable class_437 parent, class_2960 icon, class_2561 component, List<AbstractConfig<?>> configs) {
        this(ConfigScreen.setScreenOnClose(parent), icon, component, configs);
    }

    public ConfigScreen(@Nullable class_437 parent, class_2960 icon, class_2561 component, List<AbstractConfig<?>> configs, int topPadding, int bottomPadding, int sidePadding) {
        this(ConfigScreen.setScreenOnClose(parent), icon, component, configs, topPadding, bottomPadding, sidePadding);
    }

    public ConfigScreen(Runnable onClose, class_2960 icon, class_2561 component, List<AbstractConfig<?>> configs) {
        this(onClose, icon, component, configs, 20, 10, 20, 15);
    }

    public ConfigScreen(@Nullable Runnable onClose, class_2960 icon, class_2561 component, List<AbstractConfig<?>> configs, int topPadding, int bottomPadding, int sidePadding) {
        this(onClose, icon, component, configs, topPadding, bottomPadding, sidePadding, 15);
    }

    public ConfigScreen(@Nullable Runnable onClose, class_2960 icon, class_2561 component, List<AbstractConfig<?>> configs, int topPadding, int bottomPadding, int sidePadding, int titleSpacing) {
        super(onClose, icon, component, topPadding, bottomPadding, sidePadding, titleSpacing);
        this.configFiles = configs;
        this.checkboxListeners = new LinkedList<OnCheckboxChangeEvent>();
    }

    @Override
    protected LayoutComponent<?, ?> initContent() {
        VerticalStack content = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).centerHorizontal();
        content.addSpacer(4);
        content.add((LayoutComponent)this.fromConfigFiles(this.configFiles));
        VerticalStack verticalScroll = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fill()).setDebugName("vertical scroll");
        verticalScroll.addScrollable(content);
        Container main = new Container(ConfigScreen.fill(), ConfigScreen.fill()).addChild(verticalScroll);
        main.setBackgroundColor(0x77000000);
        main.setPadding(4, 0, 0, 0);
        HorizontalStack buttons = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fixed(20)).setDebugName("buttons");
        buttons.addFiller();
        buttons.addButton(ConfigScreen.fit(), ConfigScreen.fit(), class_5244.field_24334).onPress(bt -> this.closeScreen());
        VerticalStack all = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fill()).setDebugName("all");
        all.add((LayoutComponent)main);
        all.addSpacer(3);
        all.add((LayoutComponent)buttons);
        return all;
    }

    protected LayoutComponent<?, ?> fromConfigFiles(List<AbstractConfig<?>> files) {
        List<AbstractConfig.Group> groups = AbstractConfig.getAllGroups(files);
        VerticalStack content = (VerticalStack)((VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).alignTop()).setDebugName("Config - " + AbstractConfig.getAllCategories(files));
        for (AbstractConfig.Group group : groups) {
            this.addGroupHeader(content, group);
            content.indent(8).add((LayoutComponent)this.fromConfigGroup(group, files));
            this.addGroupFooter(content, group);
        }
        return content;
    }

    protected void addGroupHeader(VerticalStack content, AbstractConfig.Group group) {
        class_2561 text = this.getGroupTitle(group);
        class_2583 s = text.method_10866().method_10982(Boolean.valueOf(true));
        content.add((LayoutComponent)new Text(ConfigScreen.fit(), ConfigScreen.fit(), (class_2561)text.method_27661().method_10862(s)).alignLeft());
        content.addSpacer(4);
    }

    protected void addGroupFooter(VerticalStack content, AbstractConfig.Group group) {
        content.addSpacer(8);
    }

    protected LayoutComponent<?, ?> finalizeGroupContent(AbstractConfig.Group group, VerticalStack content) {
        return content.alignLeft();
    }

    protected LayoutComponent<?, ?> fromConfigGroup(AbstractConfig.Group group, List<AbstractConfig<?>> configFiles) {
        List<AbstractConfig.Value<?, ?>> sortedValues = AbstractConfig.getAllVisibleValues(group, configFiles);
        VerticalStack content = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Group - " + group.title());
        List<AbstractConfig.Value<?, ?>> toplevelValues = this.getDependantValues(null, sortedValues);
        this.fromValues(group, sortedValues, toplevelValues, content);
        return this.finalizeGroupContent(group, content);
    }

    private void fromValues(AbstractConfig.Group group, List<AbstractConfig.Value<?, ?>> allValues, List<AbstractConfig.Value<?, ?>> values, VerticalStack content) {
        for (AbstractConfig.Value<?, ?> value : values) {
            LayoutElement element = this.fromConfig(group, value);
            if (element == null) continue;
            content.add((LayoutComponent)element.component);
            content.addSpacer(2);
            List<AbstractConfig.Value<?, ?>> dependantValues = this.getDependantValues(value, allValues);
            if (dependantValues.isEmpty()) continue;
            VerticalStack subContent = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Dependencies - " + value.token.path() + "." + value.token.key());
            this.fromValues(group, allValues, dependantValues, subContent);
            HorizontalStack indent = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Dependency - " + value.token.path() + "." + value.token.key());
            indent.addSpacer(element.bestIndent);
            indent.add((LayoutComponent)subContent);
            content.add((LayoutComponent)indent);
            content.addSpacer(8);
        }
    }

    protected LayoutElement fromConfig(AbstractConfig.Group group, AbstractConfig.Value<?, ?> value) {
        if (value instanceof AbstractConfig.BooleanValue) {
            AbstractConfig.BooleanValue b = (AbstractConfig.BooleanValue)value;
            return this.fromBooleanConfig(group, b);
        }
        if (value instanceof AbstractConfig.FloatValue) {
            AbstractConfig.FloatValue f = (AbstractConfig.FloatValue)value;
            return this.fromFloatConfig(group, f);
        }
        if (value instanceof AbstractConfig.IntValue) {
            AbstractConfig.IntValue f = (AbstractConfig.IntValue)value;
            return this.fromIntConfig(group, f);
        }
        return null;
    }

    protected LayoutElement fromIntConfig(AbstractConfig.Group group, AbstractConfig.IntValue value) {
        class_2561 desc = this.getValueDescription(value);
        VerticalStack stack = new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit());
        Range slider = (Range)stack.addRange(ConfigScreen.fill(), ConfigScreen.fit(), this.getValueTitle(value), value.getMin(), value.getMax(), (Integer)value.getRaw()).onChange((sl, f) -> {
            value.set(f);
            this.onChangeIntRange(value, sl, f);
        }).setDebugName("Config - " + value.token.path() + "." + value.token.key());
        if (value.hasDependency()) {
            this.checkboxListeners.add((changedValue, cb, state) -> {
                if (value.getDependency().equals(changedValue)) {
                    slider.setEnabled(state);
                }
            });
        }
        if (desc != null) {
            HorizontalStack indented = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Config - " + value.token.path() + "." + value.token.key() + ".descIndent");
            indented.addSpacer(2);
            ((MultiLineText)indented.addMultilineText(ConfigScreen.fill(), ConfigScreen.fit(), MultiLineText.parse(desc)).alignLeft()).setColor(ColorHelper.GRAY);
            stack.addSpacer(2);
            stack.add((LayoutComponent)indented);
            stack.addSpacer(8);
        }
        return new LayoutElement(stack, 8);
    }

    protected LayoutElement fromFloatConfig(AbstractConfig.Group group, AbstractConfig.FloatValue value) {
        class_2561 desc = this.getValueDescription(value);
        VerticalStack stack = new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit());
        Range slider = (Range)stack.addRange(ConfigScreen.fill(), ConfigScreen.fit(), this.getValueTitle(value), value.getMin(), value.getMax(), ((Float)value.getRaw()).floatValue()).onChange((sl, f) -> {
            value.set(f);
            this.onChangeFloatRange(value, sl, f);
        }).setDebugName("Config - " + value.token.path() + "." + value.token.key());
        if (value.hasDependency()) {
            this.checkboxListeners.add((changedValue, cb, state) -> {
                if (value.getDependency().equals(changedValue)) {
                    slider.setEnabled(state);
                }
            });
        }
        if (desc != null) {
            HorizontalStack indented = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Config - " + value.token.path() + "." + value.token.key() + ".descIndent");
            indented.addSpacer(2);
            ((MultiLineText)indented.addMultilineText(ConfigScreen.fill(), ConfigScreen.fit(), MultiLineText.parse(desc)).alignLeft()).setColor(ColorHelper.GRAY);
            stack.addSpacer(2);
            stack.add((LayoutComponent)indented);
            stack.addSpacer(8);
        }
        return new LayoutElement(stack, 8);
    }

    protected LayoutElement fromBooleanConfig(AbstractConfig.Group group, AbstractConfig.BooleanValue value) {
        class_2561 desc = this.getValueDescription(value);
        Checkbox checkBox = (Checkbox)new Checkbox(ConfigScreen.fit(), ConfigScreen.fit(), this.getValueTitle(value), (Boolean)value.getRaw(), desc == null).onChange((cb, b) -> {
            value.set(b);
            this.onChange(value, cb, b);
        }).setDebugName("Config - " + value.token.path() + "." + value.token.key());
        if (value.hasDependency()) {
            this.checkboxListeners.add((changedValue, cb, state) -> {
                if (value.getDependency().equals(changedValue)) {
                    checkBox.setEnabled(state);
                }
            });
        }
        if (desc == null) {
            return new LayoutElement(checkBox, 8);
        }
        VerticalStack descCol = (VerticalStack)((VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).alignLeft()).setDebugName("Config Labels- " + value.token.path() + "." + value.token.key());
        descCol.addSpacer(0);
        descCol.addText(ConfigScreen.fit(), ConfigScreen.fit(), this.getValueTitle(value)).alignLeft();
        descCol.addSpacer(2);
        ((MultiLineText)descCol.addMultilineText(ConfigScreen.fill(), ConfigScreen.fit(), MultiLineText.parse(desc)).alignLeft()).setColor(ColorHelper.GRAY);
        descCol.addSpacer(4);
        HorizontalStack row = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Config - " + value.token.path() + "." + value.token.key());
        row.add((LayoutComponent)checkBox);
        row.add((LayoutComponent)descCol);
        return new LayoutElement(row, 24);
    }

    protected <T, R extends AbstractConfig.Value<T, R>> class_2561 getGroupTitle(AbstractConfig.Group group) {
        return class_2561.method_43471((String)("title.config.group." + group.modID() + "." + group.title()));
    }

    protected <T, R extends AbstractConfig.Value<T, R>> class_2561 getValueDescription(AbstractConfig.Value<T, R> option) {
        StringBuilder sb = new StringBuilder("description.config.");
        if (option.getParentFile() != null) {
            sb.append(((AbstractConfig)option.getParentFile()).category).append(".");
        }
        sb.append(option.token.path()).append(".").append(option.token.key());
        String key = sb.toString();
        if (!class_2477.method_10517().method_4678(key)) {
            return null;
        }
        return class_2561.method_43471((String)key);
    }

    protected <T, R extends AbstractConfig.Value<T, R>> class_2561 getValueTitle(AbstractConfig.Value<T, R> option) {
        StringBuilder sb = new StringBuilder("title.config.");
        if (option.getParentFile() != null) {
            sb.append(((AbstractConfig)option.getParentFile()).category).append(".");
        }
        sb.append(option.token.path()).append(".").append(option.token.key());
        return class_2561.method_43471((String)sb.toString());
    }

    protected List<AbstractConfig.Value<?, ?>> getDependantValues(AbstractConfig.Value<?, ?> source, List<AbstractConfig.Value<?, ?>> sortedValues) {
        LinkedList dependantValues = new LinkedList();
        for (AbstractConfig.Value<?, ?> value : sortedValues) {
            if (value.getDependency() != source) continue;
            dependantValues.add(value);
        }
        return dependantValues;
    }

    protected void onChange(AbstractConfig.Value<?, ?> value, Checkbox cb, boolean newValue) {
        this.checkboxListeners.forEach(l -> l.onChange(value, cb, newValue));
    }

    protected void onChangeFloatRange(AbstractConfig.Value<?, ?> value, Range<Float> r, Number newValue) {
    }

    protected void onChangeIntRange(AbstractConfig.Value<?, ?> value, Range<Integer> r, Number newValue) {
    }

    protected record LayoutElement(LayoutComponent<?, ?> component, int bestIndent) {
    }

    @FunctionalInterface
    public static interface OnCheckboxChangeEvent {
        public void onChange(AbstractConfig.Value<?, ?> var1, Checkbox var2, boolean var3);
    }
}

