/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Size;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class RenderHelper {
    public static void outline(class_332 guiGraphics, int x0, int y0, int x1, int y1, int color) {
        RenderHelper.outline(guiGraphics, x0, y0, x1, y1, color, color);
    }

    public static void outline(class_332 guiGraphics, int x0, int y0, int x1, int y1, int color1, int color2) {
        int n;
        if (x1 < x0) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y1 < y0) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        Matrix4f transform = guiGraphics.method_51448().method_23760().method_23761();
        RenderHelper.innerHLine(transform, x0, --x1, y0, color1);
        RenderHelper.innerVLine(transform, x0, y0 + 1, --y1, color1);
        RenderHelper.innerHLine(transform, x0 + 1, x1, y1, color2);
        RenderHelper.innerVLine(transform, x1, y0 + 1, y1 - 1, color2);
    }

    public static void hLine(class_332 guiGraphics, int x0, int x1, int y, int color) {
        if (x1 < x0) {
            int m = x0;
            x0 = x1;
            x1 = m;
        }
        RenderHelper.innerHLine(guiGraphics.method_51448().method_23760().method_23761(), x0, x1, y, color);
    }

    protected static void innerHLine(Matrix4f transform, int x0, int x1, int y, int color) {
        RenderHelper.innerFill(transform, x0, y, x1 + 1, y + 1, color);
    }

    public static void vLine(class_332 guiGraphics, int x, int y0, int y1, int color) {
        if (y1 < y0) {
            int m = y0;
            y0 = y1;
            y1 = m;
        }
        RenderHelper.innerVLine(guiGraphics.method_51448().method_23760().method_23761(), x, y0, y1, color);
    }

    protected static void innerVLine(Matrix4f transform, int x, int y0, int y1, int color) {
        RenderHelper.innerFill(transform, x, y0, x + 1, y1 + 1, color);
    }

    private static void innerFill(Matrix4f transform, int x0, int y0, int x1, int y1, int color) {
        float[] cl = ColorHelper.toFloatArrayRGBA(color);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_22918(transform, (float)x0, (float)y1, 0.0f).method_22915(cl[0], cl[1], cl[2], cl[3]);
        bufferBuilder.method_22918(transform, (float)x1, (float)y1, 0.0f).method_22915(cl[0], cl[1], cl[2], cl[3]);
        bufferBuilder.method_22918(transform, (float)x1, (float)y0, 0.0f).method_22915(cl[0], cl[1], cl[2], cl[3]);
        bufferBuilder.method_22918(transform, (float)x0, (float)y0, 0.0f).method_22915(cl[0], cl[1], cl[2], cl[3]);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void renderImage(class_332 guiGraphics, int left, int top, class_2960 location, Size resourceSize, Rectangle uvRect, float alpha) {
        RenderHelper.renderImage(guiGraphics, left, top, uvRect.width, uvRect.height, location, resourceSize, uvRect, alpha);
    }

    public static void renderImage(class_332 guiGraphics, int left, int top, int width, int height, class_2960 location, Size resourceSize, Rectangle uvRect, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        guiGraphics.method_25293(location, left, top, width, height, (float)uvRect.left, (float)uvRect.top, uvRect.width, uvRect.height, resourceSize.width(), resourceSize.height());
    }
}

