/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import com.google.common.collect.ImmutableList;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.LineWithWidth;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.TextProvider;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;

public class MultiLineText
extends LayoutComponent<MultiLineTextRenderer, MultiLineText> {
    class_2561 text;
    int color = ColorHelper.DEFAULT_TEXT;
    protected class_5489 multiLineLabel;
    int bufferedContentWidth = 0;
    List<LineWithWidth> lines = List.of();
    private boolean focused;

    public MultiLineText(Value width, Value height, class_2561 text) {
        super(width, height, new MultiLineTextRenderer());
        ((MultiLineTextRenderer)this.renderer).linkedComponent = this;
        this.text = text;
        this.updatedContentWidth();
    }

    public MultiLineText setColor(int cl) {
        this.color = cl;
        return this;
    }

    public static class_2561 parse(class_2561 text) {
        String[] parts = text.getString().split("\\*\\*");
        if (parts.length > 0) {
            boolean bold = false;
            class_5250 c = class_2561.method_43470((String)parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                bold = !bold;
                c.method_10852((class_2561)class_2561.method_43470((String)parts[i]).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(bold))));
            }
            return c;
        }
        return text;
    }

    public MultiLineText setText(class_2561 text) {
        this.text = text;
        this.updatedContentWidth();
        if (this.multiLineLabel != null) {
            this.multiLineLabel = this.createVanillaComponent();
        }
        return this;
    }

    protected class_5489 createVanillaComponent() {
        int wd = this.relativeBounds == null ? this.width.calculatedSize() : this.relativeBounds.width;
        this.lines = (List)((MultiLineTextRenderer)this.renderer).getFont().method_1728((class_5348)this.text, wd).stream().map(component -> new LineWithWidth((class_5481)component, ((MultiLineTextRenderer)this.renderer).getFont().method_30880(component))).collect(ImmutableList.toImmutableList());
        return class_5489.method_30890((class_327)((MultiLineTextRenderer)this.renderer).getFont(), (class_2561)this.text, (int)wd);
    }

    protected void updatedContentWidth() {
        String[] lines = this.text.getString().split("\n");
        if (lines.length == 0) {
            this.bufferedContentWidth = 0;
        } else {
            String line = lines[0];
            for (int i = 1; i < lines.length; ++i) {
                if (lines[i].length() <= line.length()) continue;
                line = lines[i];
            }
            this.bufferedContentWidth = ((MultiLineTextRenderer)this.renderer).getWidth((class_2561)class_2561.method_43470((String)line));
        }
    }

    @Override
    protected void onBoundsChanged() {
        super.onBoundsChanged();
        this.multiLineLabel = this.createVanillaComponent();
    }

    @Override
    public int getContentWidth() {
        return this.bufferedContentWidth;
    }

    @Override
    public int getContentHeight() {
        return ((MultiLineTextRenderer)this.renderer).getHeight(this.text);
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_25365(boolean bl) {
        this.focused = bl;
    }

    @Override
    public boolean method_25405(double d, double e) {
        return false;
    }

    protected static class MultiLineTextRenderer
    implements ComponentRenderer,
    TextProvider {
        MultiLineText linkedComponent;

        protected MultiLineTextRenderer() {
        }

        @Override
        public int getWidth(class_2561 c) {
            return this.getFont().method_30880(c.method_30937());
        }

        @Override
        public int getHeight(class_2561 c) {
            if (this.linkedComponent == null) {
                return 20;
            }
            class_5489 ml = this.linkedComponent.multiLineLabel != null ? this.linkedComponent.multiLineLabel : this.linkedComponent.createVanillaComponent();
            return ml.method_30887() * this.getLineHeight(c);
        }

        @Override
        public void renderInBounds(class_332 guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
            if (this.linkedComponent != null && this.linkedComponent.multiLineLabel != null) {
                int top = bounds.height - this.getHeight(this.linkedComponent.text);
                if (this.linkedComponent.vAlign == Alignment.MIN) {
                    top = 0;
                }
                if (this.linkedComponent.vAlign == Alignment.CENTER) {
                    top /= 2;
                }
                if (this.linkedComponent.hAlign == Alignment.CENTER) {
                    this.linkedComponent.multiLineLabel.method_30889(guiGraphics, bounds.width / 2, top, this.getLineHeight(this.linkedComponent.text), this.linkedComponent.color);
                } else if (this.linkedComponent.hAlign == Alignment.MAX) {
                    int lineY = 0;
                    int lineHeight = this.getLineHeight(this.linkedComponent.text);
                    for (LineWithWidth textWithWidth : this.linkedComponent.lines) {
                        guiGraphics.method_35720(this.getFont(), textWithWidth.text(), this.linkedComponent.width.calculatedSize() - textWithWidth.width(), lineY, this.linkedComponent.color);
                        lineY += lineHeight;
                    }
                } else {
                    this.linkedComponent.multiLineLabel.method_30893(guiGraphics, 0, top, this.getLineHeight(this.linkedComponent.text), this.linkedComponent.color);
                }
            }
        }
    }
}

