/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf.shapes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.Rotatable;
import de.ambertation.wunderlib.math.sdf.shapes.BaseShape;
import net.minecraft.class_7243;

public class Cylinder
extends BaseShape
implements Rotatable {
    public static final Transform DEFAULT_TRANSFORM = Transform.of(Float3.of(0.0, 0.0, 0.0), Float3.of(5.0, 8.0, 5.0));
    public static final MapCodec<Cylinder> DIRECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Transform.CODEC.fieldOf("transform").orElse((Object)Transform.IDENTITY).forGetter(o -> o.transform), (App)Codec.INT.fieldOf("material").orElse((Object)0).forGetter(BaseShape::getMaterialIndex)).apply((Applicative)instance, Cylinder::new));
    public static final class_7243<Cylinder> CODEC = class_7243.method_42116(DIRECT_CODEC);

    @Override
    public class_7243<? extends SDF> codec() {
        return CODEC;
    }

    public Cylinder(Transform t, int matIndex) {
        super(t, matIndex);
    }

    public Cylinder(Transform t) {
        this(t, 0);
    }

    public Cylinder(Float3 center, double height, double radius) {
        this(Transform.of(center, Float3.of(2.0 * radius, height, 2.0 * radius)), 0);
    }

    public double getHeight() {
        return this.transform.size.y;
    }

    public double getRadius() {
        return Math.abs(Math.min(this.transform.size.x, this.transform.size.z) / 2.0);
    }

    @Override
    public double dist(Float3 p) {
        p = this.getParentTransformMatrix().inverted().transform(p);
        p = p.sub(this.transform.center).unRotate(this.transform.rotation).div(this.transform.size);
        return Math.max((p.xz().length() - 0.5) * this.transform.size.xz().minComp(), (Math.abs(p.y) - 0.5) * this.transform.size.y);
    }

    @Override
    public Transform defaultTransform() {
        return DEFAULT_TRANSFORM;
    }
}

