/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1293;
import net.minecraft.class_1322;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellPowerTags;
import net.spell_power.api.SpellResistance;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.AttributesConfig;
import net.spell_power.internals.AttributeUtil;
import net.spell_power.internals.CrossFunctionalAttributes;
import net.spell_power.internals.SpellStatusEffect;
import net.tinyconfig.ConfigManager;

public class SpellPowerMod
implements ModInitializer {
    public static final String ID = "spell_power";
    public static final ConfigManager<AttributesConfig> attributesConfig = new ConfigManager("attributes", (Object)AttributesConfig.defaults()).builder().setDirectory("spell_power").sanitize(true).validate(AttributesConfig::isValid).build();
    private static boolean potionsRegistered = false;
    public static AttributesConfig.AttributeScope attributeScopeOverride = null;

    public void onInitialize() {
        attributesConfig.refresh();
    }

    public static void registerAttributes() {
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            entry.getValue().registerAttribute();
        }
        for (SpellResistance.Attributes.Entry resistance : SpellResistance.Attributes.all) {
            resistance.registerAttribute();
        }
        SpellSchool genericSpellSchool = SpellSchools.GENERIC;
        for (SpellSchool school : SpellSchools.all()) {
            school.registerAttribute();
            if (school == genericSpellSchool || !school.ownsAttribute()) continue;
            CrossFunctionalAttributes.power(school.attributeEntry, genericSpellSchool.attributeEntry);
        }
        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
            List enchantmentAttributes;
            if (enchantment.method_40220(SpellPowerTags.Enchantments.REQUIRES_MATCHING_ATTRIBUTE) && (enchantmentAttributes = (List)((class_1887)enchantment.comp_349()).comp_2689().method_57829(class_9701.field_51668)) != null && !enchantmentAttributes.isEmpty()) {
                boolean intersect;
                class_9285 itemAttributes = (class_9285)target.method_57353().method_57829(class_9334.field_49636);
                if (itemAttributes.comp_2393().isEmpty()) {
                    itemAttributes = target.method_7909().method_7844();
                }
                if (!(intersect = AttributeUtil.attributesIntersect(enchantmentAttributes, itemAttributes))) {
                    return TriState.FALSE;
                }
            }
            return TriState.DEFAULT;
        });
    }

    public static void registerStatusEffects() {
        class_2960 modifierId = class_2960.method_60655((String)ID, (String)"potion_effect");
        float bonus_per_stack = 0.1f;
        for (SpellSchool spellSchool : SpellSchools.all()) {
            class_2960 id = spellSchool.id;
            if (spellSchool.ownedBoostEffect == null || spellSchool.attributeEntry == null) continue;
            spellSchool.ownedBoostEffect.method_5566(spellSchool.attributeEntry, modifierId, (double)bonus_per_stack, class_1322.class_1323.field_6330);
            class_2378.method_10226((class_2378)class_7923.field_41174, (String)id.toString(), (Object)spellSchool.ownedBoostEffect);
        }
        for (Map.Entry entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry secondary = (SpellPowerMechanics.Entry)entry.getValue();
            class_2960 id = secondary.id;
            SpellStatusEffect.Config config = ((AttributesConfig)SpellPowerMod.attributesConfig.value).secondary_effects.get(secondary.name);
            if (config != null) {
                bonus_per_stack = config.bonus_per_stack;
            }
            secondary.boostEffect.method_5566(secondary.attributeEntry, modifierId, (double)bonus_per_stack, class_1322.class_1323.field_6330);
            class_2378.method_10226((class_2378)class_7923.field_41174, (String)id.toString(), (Object)secondary.boostEffect);
        }
    }

    public static void registerPotionsInternal() {
        attributesConfig.refresh();
        if (((AttributesConfig)SpellPowerMod.attributesConfig.value).register_potions) {
            SpellPowerMod.registerPotions();
        }
    }

    public static void registerPotions() {
        if (potionsRegistered) {
            return;
        }
        potionsRegistered = true;
        for (SpellSchool spellSchool : SpellSchools.all()) {
            if (spellSchool.archetype != SpellSchool.Archetype.MAGIC || spellSchool.id.method_12832().contains("generic")) continue;
            spellSchool.registerPotion();
        }
        for (Map.Entry entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry mechanic = (SpellPowerMechanics.Entry)entry.getValue();
            class_6880 entry2 = class_7923.field_41174.method_47983((Object)mechanic.boostEffect);
            if (entry2 == null) continue;
            class_1842 potion = new class_1842(new class_1293[]{new class_1293(entry2, 3600)});
            class_2378.method_10230((class_2378)class_7923.field_41179, (class_2960)SpellPowerMod.potionIdFrom(mechanic.id), (Object)potion);
        }
    }

    public static class_2960 potionIdFrom(class_2960 id) {
        return class_2960.method_60655((String)id.method_12836(), (String)(id.method_12836() + "." + id.method_12832()));
    }

    public static AttributesConfig.AttributeScope attributeScope() {
        return attributeScopeOverride != null ? attributeScopeOverride : ((AttributesConfig)SpellPowerMod.attributesConfig.value).attributes_container_injection_scope;
    }
}

