/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.item.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7699;

public class TanksUpgradeItem
extends UpgradeItem {
    public TanksUpgradeItem(class_1792.class_1793 pProperties) {
        super(pProperties.method_57349(ModDataComponents.FLUIDS, (Object)Fluids.empty()), "tanks_upgrade");
    }

    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.enableTanksUpgrade && super.method_45382(enabledFeatures);
    }

    public static boolean canBePutInBackpack(long backpackFluidStorageSize, class_1799 tanksUpgrade) {
        long[] fluidTanks = new long[]{0L, 0L};
        if (tanksUpgrade.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.method_57824(ModDataComponents.FLUIDS);
            fluidTanks[0] = fluidTanks2.leftFluidStack().getAmount();
            fluidTanks[1] = fluidTanks2.rightFluidStack().getAmount();
        }
        return backpackFluidStorageSize >= fluidTanks[0] && backpackFluidStorageSize >= fluidTanks[1];
    }

    public static FluidVariantWrapper getLeftFluidStack(class_1799 tanksUpgrade) {
        if (tanksUpgrade.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.method_57824(ModDataComponents.FLUIDS);
            return fluidTanks2.leftFluidStack();
        }
        return FluidVariantWrapper.blank();
    }

    public static FluidVariantWrapper getRightFluidStack(class_1799 tanksUpgrade) {
        if (tanksUpgrade.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.method_57824(ModDataComponents.FLUIDS);
            return fluidTanks2.rightFluidStack();
        }
        return FluidVariantWrapper.blank();
    }

    public static RenderInfo writeToRenderData() {
        class_2487 tag = new class_2487();
        tag.method_10566("LeftTank", (class_2520)new class_2487());
        tag.method_10566("RightTank", (class_2520)new class_2487());
        return new RenderInfo(tag);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        if (stack.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks = (Fluids)stack.method_57824(ModDataComponents.FLUIDS);
            FluidVariantWrapper leftFluidStack = fluidTanks.leftFluidStack();
            FluidVariantWrapper rightFluidStack = fluidTanks.rightFluidStack();
            if (!leftFluidStack.isEmpty()) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(FluidTypeHelper.getFluidVariantName(leftFluidStack.fluidVariant()).getString() + ": " + leftFluidStack.getAmount() + "mB")).method_27692(class_124.field_1078));
            }
            if (!rightFluidStack.isEmpty()) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(FluidTypeHelper.getFluidVariantName(rightFluidStack.fluidVariant()).getString() + ": " + rightFluidStack.getAmount() + "mB")).method_27692(class_124.field_1078));
            }
        }
    }
}

