/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.item;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.entity.BackpackItemEntity;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5620;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackItem
extends class_1747 {
    public final class_2960 texture;

    public TravelersBackpackItem(class_2248 block, String name) {
        this(block, class_2960.method_60655((String)"travelersbackpack", (String)("textures/model/" + name.toLowerCase(Locale.ENGLISH) + ".png")));
    }

    public TravelersBackpackItem(class_2248 block, class_2960 texture) {
        super(block, new class_1792.class_1793().method_7889(1).method_57349(ModDataComponents.TIER, (Object)0).method_57349(ModDataComponents.SLEEPING_BAG_COLOR, (Object)class_1767.field_7964.method_7789()).method_57349(ModDataComponents.IS_VISIBLE, (Object)true));
        this.texture = texture;
    }

    public class_2960 getBackpackTexture() {
        return this.texture;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (hand == class_1268.field_5810 || player.method_18276()) {
            return class_1271.method_22431((Object)itemstack);
        }
        if (!TravelersBackpackConfig.getConfig().backpackSettings.allowOnlyEquippedBackpack) {
            if (!level.field_9236) {
                BackpackContainer.openBackpack((class_3222)player, player.method_31548().method_7391(), (byte)1);
            }
        } else if (!ComponentUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
            ServerActions.equipBackpack(player);
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        return class_1271.method_29237((Object)itemstack, (boolean)level.field_9236);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1269 interactionResult = this.method_7712(new class_1750(context));
        return !interactionResult.method_23665() ? this.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467() : interactionResult;
    }

    public class_1269 method_7712(class_1750 context) {
        if (!context.method_7716() || context.method_20287() == class_1268.field_5808 && context.method_8036() != null && !context.method_8036().method_18276()) {
            return class_1269.field_5814;
        }
        class_1750 blockitemusecontext = this.method_16356(context);
        if (blockitemusecontext == null) {
            return class_1269.field_5814;
        }
        class_2680 blockstate = this.method_7707(blockitemusecontext);
        if (blockstate == null) {
            return class_1269.field_5814;
        }
        if (!this.method_7708(blockitemusecontext, blockstate)) {
            return class_1269.field_5814;
        }
        class_2338 blockpos = blockitemusecontext.method_8037();
        class_1937 level = blockitemusecontext.method_8045();
        class_1657 player = blockitemusecontext.method_8036();
        class_1799 itemstack = blockitemusecontext.method_8041();
        class_2680 blockstate1 = level.method_8320(blockpos);
        if (blockstate1.method_27852(blockstate.method_26204())) {
            this.method_7710(blockpos, level, player, itemstack, blockstate1);
            blockstate1.method_26204().method_9567(level, blockpos, blockstate1, (class_1309)player, itemstack);
            class_2586 class_25862 = level.method_8321(blockpos);
            if (class_25862 instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity = (BackpackBlockEntity)class_25862;
                blockEntity.setBackpack(itemstack, (class_7225.class_7874)level.method_30349());
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_1191.method_23889(serverPlayer, blockpos, itemstack);
            }
        }
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28164, blockpos);
        class_2498 soundtype = blockstate1.method_26231();
        level.method_8396(player, blockpos, this.method_19260(blockstate1), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        if (player == null || !player.method_31549().field_7477) {
            itemstack.method_7934(1);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    protected boolean method_7710(class_2338 pPos, class_1937 pLevel, @Nullable class_1657 pPlayer, class_1799 pStack, class_2680 pState) {
        return TravelersBackpackItem.updateCustomBlockEntityTag(pLevel, pPlayer, pPos, pStack);
    }

    public static boolean updateCustomBlockEntityTag(class_1937 pLevel, @Nullable class_1657 pPlayer, class_2338 pPos, class_1799 pStack) {
        MinecraftServer minecraftserver = pLevel.method_8503();
        if (minecraftserver == null) {
            return false;
        }
        class_2586 blockEntity = pLevel.method_8321(pPos);
        if (blockEntity != null && (pLevel.field_9236 || !blockEntity.method_11011() || pPlayer != null && pPlayer.method_7338())) {
            blockEntity.method_58683(pStack.method_7972());
            return true;
        }
        return false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        if (stack.method_57826(ModDataComponents.TIER)) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)("tier.travelersbackpack." + Tiers.of((Integer)stack.method_57824(ModDataComponents.TIER)).getName())));
        }
        if (stack.method_57826(ModDataComponents.BACKPACK_CONTAINER) && !BackpackDeathHelper.isCtrlPressed()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.travelersbackpack.inventory_tooltip").method_27692(class_124.field_1078));
        }
        if (TravelersBackpackConfig.getConfig().client.obtainTips) {
            if (stack.method_7909() == ModItems.BAT_TRAVELERS_BACKPACK) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"obtain.travelersbackpack.bat").method_27692(class_124.field_1078));
            }
            if (stack.method_7909() == ModItems.VILLAGER_TRAVELERS_BACKPACK) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"obtain.travelersbackpack.villager").method_27692(class_124.field_1078));
            }
            if (stack.method_7909() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"obtain.travelersbackpack.iron_golem").method_27692(class_124.field_1078));
            }
        }
        if (BackpackAbilities.isOnList(BackpackAbilities.ALL_ABILITIES_LIST, stack) && TravelersBackpackConfig.isAbilityAllowed(stack) && TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities) {
            if (BackpackDeathHelper.isShiftPressed()) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)("ability.travelersbackpack." + this.method_7866(stack).replaceAll("block.travelersbackpack.", ""))).method_27692(class_124.field_1078));
                if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((class_2561)class_2561.method_43471((String)"ability.travelersbackpack.item_and_block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((class_2561)class_2561.method_43471((String)"ability.travelersbackpack.block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((class_2561)class_2561.method_43471((String)"ability.travelersbackpack.item"));
                }
            } else {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"ability.travelersbackpack.hold_shift").method_27692(class_124.field_1078));
            }
        }
    }

    @Nullable
    public class_1297 createEntity(class_1937 level, class_1297 entity, class_1799 itemstack) {
        if (!(entity instanceof class_1542)) {
            return null;
        }
        class_1542 itemEntity = (class_1542)entity;
        if (!this.hasCustomData(itemEntity.method_6983())) {
            return null;
        }
        return this.createBackpackEntity(level, itemEntity, itemstack);
    }

    public boolean hasCustomData(class_1799 stack) {
        if (((BackpackContainerContents)stack.method_57825(ModDataComponents.BACKPACK_CONTAINER, (Object)BackpackContainerContents.fromItems(0, List.of()))).getItems().stream().anyMatch(itemStack -> !itemStack.method_7960())) {
            return true;
        }
        if (((BackpackContainerContents)stack.method_57825(ModDataComponents.UPGRADES, (Object)BackpackContainerContents.fromItems(0, List.of()))).getItems().stream().anyMatch(itemStack -> !itemStack.method_7960())) {
            return true;
        }
        if (((BackpackContainerContents)stack.method_57825(ModDataComponents.TOOLS_CONTAINER, (Object)BackpackContainerContents.fromItems(0, List.of()))).getItems().stream().anyMatch(itemStack -> !itemStack.method_7960())) {
            return true;
        }
        if (((Boolean)stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)false)).booleanValue() || (Integer)stack.method_57825(ModDataComponents.COOLDOWN, (Object)0) > 0) {
            return true;
        }
        return (Integer)stack.method_57825(ModDataComponents.TIER, (Object)0) >= Tiers.DIAMOND.getOrdinal();
    }

    @Nullable
    private BackpackItemEntity createBackpackEntity(class_1937 level, class_1542 itemEntity, class_1799 itemstack) {
        BackpackItemEntity backpackItemEntity = (BackpackItemEntity)ModItems.BACKPACK_ITEM_ENTITY.method_5883(level);
        if (backpackItemEntity != null) {
            backpackItemEntity.method_5814(itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321());
            backpackItemEntity.method_6979(itemstack.method_7972());
            backpackItemEntity.method_6982(itemEntity.field_7202);
            if (itemEntity.method_24921() != null) {
                backpackItemEntity.method_6981(itemEntity.method_24921());
            }
            backpackItemEntity.method_18799(itemEntity.method_18798());
        }
        return backpackItemEntity;
    }

    public Optional<class_5632> method_32346(class_1799 pStack) {
        return Optional.of(new BackpackTooltipComponent(pStack));
    }

    public boolean method_31568() {
        return TravelersBackpackConfig.getConfig().backpackSettings.allowShulkerBoxes;
    }

    public static void registerCauldronInteraction() {
        class_5620.field_27776.comp_1982().put(ModItems.STANDARD_TRAVELERS_BACKPACK, class_5620.field_27782);
    }
}

