/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class VoidUpgrade
extends UpgradeBase
implements IFilter,
IEnable {
    public ItemStackHandler filter;
    private final VoidFilterSettings filterSettings;

    public VoidUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount;
        this.filterSettings = new VoidFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.method_7960()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1)));
    }

    public VoidFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canVoid(class_1799 stack) {
        return this.getFilterSettings().canVoid(stack) && this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.UPGRADE_ENABLED, (Object)true);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public void remove() {
        this.upgradeManager.voidUpgrade = Optional.empty();
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new VoidWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add(new FilterSlotItemHandler(this, this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){
                    final /* synthetic */ VoidUpgrade this$0;
                    {
                        this.this$0 = this$0;
                        super(upgrade, itemHandler, index, xPosition, yPosition, activeSlotCount);
                    }

                    @Override
                    public boolean method_7682() {
                        return super.method_7682() && this.this$0.getFilter().get(0) != 2;
                    }

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                class_1799 stack = VoidUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(VoidUpgrade.this.getDataHolderSlot());
                stack.method_57379(ModDataComponents.BACKPACK_CONTAINER, (Object)InventoryHelper.itemsToList(9, VoidUpgrade.this.filter));
                VoidUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(VoidUpgrade.this.getDataHolderSlot(), stack);
                VoidUpgrade.this.getFilterSettings().updateFilter((List<class_1799>)((BackpackContainerContents)stack.method_57824(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return true;
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

