/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_7923;

public class VoidFilterSettings {
    public static final int ALLOW_MODE = 0;
    public static final int OBJECT_CATEGORY = 1;
    public static final int IGNORE_MODE = 2;
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;
    public static final int MATCH_CONTENTS = 2;
    public static final int ITEM = 0;
    public static final int MOD_ID = 1;
    public static final int IGNORE_COMPONENTS = 0;
    public static final int MATCH_COMPONENTS = 1;
    private List<class_1799> filterItems;
    private List<Integer> filterSettings;
    private ItemStackHandler storage;

    public VoidFilterSettings(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings) {
        this.filterItems = items;
        this.filterSettings = filterSettings;
        this.storage = storage;
    }

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean canVoid(class_1799 stack) {
        if (this.filterSettings.get(0) == 0) {
            return this.filterItems.stream().anyMatch(filterStack -> this.compare((class_1799)filterStack, stack));
        }
        if (this.filterSettings.get(0) == 1) {
            return this.filterItems.stream().noneMatch(filterStack -> this.compare((class_1799)filterStack, stack));
        }
        if (this.filterSettings.get(0) == 2) {
            return this.streamStorageContents().anyMatch(filterStack -> this.compare((class_1799)filterStack, stack));
        }
        return false;
    }

    public boolean compare(class_1799 stack, class_1799 other) {
        if (this.filterSettings.get(1) == 0) {
            return this.compareItemStack(stack, other);
        }
        return this.compareModId(stack, other);
    }

    public boolean compareItemStack(class_1799 stack, class_1799 other) {
        if (this.filterSettings.get(2) == 0) {
            return class_1799.method_7984((class_1799)stack, (class_1799)other);
        }
        return class_1799.method_31577((class_1799)stack, (class_1799)other);
    }

    public boolean compareModId(class_1799 stack, class_1799 other) {
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals(class_7923.field_41178.method_10221((Object)other.method_7909()).method_12836());
    }

    public void updateFilter(List<class_1799> items) {
        this.filterItems = items.stream().limit(TravelersBackpackConfig.getConfig().backpackUpgrades.voidUpgradeSettings.filterSlotCount).filter(stack -> !stack.method_7960()).toList();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }

    public Stream<class_1799> streamStorageContents() {
        ArrayList<class_1799> arrayList = new ArrayList<class_1799>();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            if (this.storage.getStackInSlot(i).method_7960()) continue;
            arrayList.add(this.storage.getStackInSlot(i));
        }
        return arrayList.stream();
    }
}

