/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundFillTankPacket;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9334;

public class TankWidget
extends UpgradeWidgetBase<TanksUpgrade> {
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = upgrade.leftTankPos;
        this.rightTankPos = upgrade.rightTankPos;
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.inTank(this.leftTankPos, mouseX, mouseY)) {
            guiGraphics.method_51434(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).leftTank), mouseX, mouseY);
        }
        if (this.inTank(this.rightTankPos, mouseX, mouseY)) {
            guiGraphics.method_51434(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        SlotPositioner pos = ((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().getSlotPositioner();
        int extendedOffset = 0;
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).leftTank, x + 8, y + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) * 18 - 2, 16.0);
        this.renderTank(guiGraphics, pos, x + 7, y);
        if (pos.isExtended()) {
            extendedOffset = 36;
        }
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).rightTank, x + 196 + extendedOffset, y + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) * 18 - 2, 16.0);
        this.renderTank(guiGraphics, pos, x + 195 + extendedOffset, y);
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.inTank(this.leftTankPos, (int)pMouseX, (int)pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255())) {
            PacketDistributor.sendToServer(new ServerboundFillTankPacket(true));
            return true;
        }
        if (this.inTank(this.rightTankPos, (int)pMouseX, (int)pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255())) {
            PacketDistributor.sendToServer(new ServerboundFillTankPacket(false));
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean isValid(class_1799 stack) {
        return FluidUtil.hasFluidStorageConstant(stack) || stack.method_7909() instanceof class_1812;
    }

    public void renderTank(class_332 guiGraphics, SlotPositioner pos, int x, int y) {
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7, 0, 95, 18, 18);
        for (int i = 1; i <= (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) - 2; ++i) {
            guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7 + 18 * i, 0, 113, 18, 18);
        }
        guiGraphics.method_25302(BackpackScreen.ICONS, x, y + 7 + 18 * ((((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) - 1), 0, 131, 18, 18);
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getTankTooltip(FluidTank tank) {
        Object fluidAmount;
        FluidVariantWrapper fluidStack = tank.getFluid();
        ArrayList<class_2561> tankTips = new ArrayList<class_2561>();
        String fluidName = !fluidStack.isEmpty() ? FluidTypeHelper.getFluidVariantName(fluidStack.fluidVariant()).getString() : class_1074.method_4662((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object object = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : class_1074.method_4662((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651) != null && fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651).isPresent()) {
            fluidName = null;
            class_1844 contents = (class_1844)fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651).get();
            if (class_310.method_1551().field_1687 != null) {
                contents.method_47372(tankTips::add, 1.0f, class_310.method_1551().field_1687.method_54719().method_54748());
            }
        }
        if (fluidName != null) {
            tankTips.add((class_2561)class_2561.method_43470((String)fluidName));
        }
        tankTips.add((class_2561)class_2561.method_43470((String)fluidAmount));
        return tankTips;
    }

    public boolean inTank(Point tankPos, int mouseX, int mouseY) {
        return ((BackpackScreen)this.screen).getGuiLeft() + tankPos.x() <= mouseX && mouseX <= tankPos.x() + this.tankWidth + ((BackpackScreen)this.screen).getGuiLeft() && tankPos.y() + ((BackpackScreen)this.screen).getGuiTop() <= mouseY && mouseY <= tankPos.y() + this.tankHeight + ((BackpackScreen)this.screen).getGuiTop();
    }
}

