/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class MagnetUpgrade
extends UpgradeBase
implements IFilter,
IEnable,
ITickableUpgrade {
    private static final int COOLDOWN = 30;
    public ItemStackHandler filter;
    private final MagnetFilterSettings filterSettings;

    public MagnetUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.filterSlotCount;
        this.filterSettings = new MagnetFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.method_7960()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    }

    public MagnetFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.UPGRADE_ENABLED, (Object)true);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public void remove() {
        this.upgradeManager.magnetUpgrade = Optional.empty();
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.filterSlotCount;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new MagnetWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.filterSlotCount;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add(new FilterSlotItemHandler(this, this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.teleportNearbyItems(player, level);
        this.setCooldown(30);
    }

    public void teleportNearbyItems(class_1657 player, class_1937 level) {
        if (this.isEnabled()) {
            if (level.field_9236) {
                return;
            }
            int radius = TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.pullRange;
            class_238 area = new class_238(player.method_19538().method_1031((double)(-radius), (double)(-radius), (double)(-radius)), player.method_19538().method_1031((double)radius, (double)radius, (double)radius));
            List items = level.method_18023((class_5575)class_1299.field_6052, area, item -> !(!item.method_5805() || level.field_9236 && item.field_6012 <= 1 || item.field_7200 != null && item.field_7200.equals(player.method_5667()) && item.field_6012 <= 80 || item.method_6983().method_7960() || !this.getFilterSettings().canPickup(item.method_6983())));
            items.forEach(item -> item.method_5814(player.method_23317(), player.method_23318(), player.method_23321()));
        }
    }

    private ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                class_1799 stack = MagnetUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(MagnetUpgrade.this.getDataHolderSlot());
                stack.method_57379(ModDataComponents.BACKPACK_CONTAINER, (Object)InventoryHelper.itemsToList(this.stacks.size(), MagnetUpgrade.this.filter));
                MagnetUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(MagnetUpgrade.this.getDataHolderSlot(), stack);
                MagnetUpgrade.this.getFilterSettings().updateFilter((List<class_1799>)((BackpackContainerContents)stack.method_57824(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return true;
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

