/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.handler.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FeedingUpgrade
extends UpgradeBase
implements IFilter,
IEnable,
ITickableUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    public ItemStackHandler filter;
    private final FeedingFilterSettings filterSettings;

    public FeedingUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount;
        this.filterSettings = new FeedingFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.method_7960()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0)));
    }

    public FeedingFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canEat(class_1657 player, class_1799 stack) {
        return this.getFilterSettings().canEat(player.method_7344(), stack) && this.isEnabled() && !player.method_7357().method_7904(stack.method_7909());
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_57825(ModDataComponents.UPGRADE_ENABLED, (Object)true);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount;
    }

    @Override
    public void remove() {
        this.upgradeManager.feedingUpgrade = Optional.empty();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new FeedingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        int activeSlotCount = TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add(new FilterSlotItemHandler(this, this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                class_1799 stack = FeedingUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(FeedingUpgrade.this.getDataHolderSlot());
                stack.method_57379(ModDataComponents.BACKPACK_CONTAINER, (Object)InventoryHelper.itemsToList(9, FeedingUpgrade.this.filter));
                FeedingUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(FeedingUpgrade.this.getDataHolderSlot(), stack);
                FeedingUpgrade.this.getFilterSettings().updateFilter((List<class_1799>)((BackpackContainerContents)stack.method_57824(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return stack.method_57826(class_9334.field_50075);
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        if (this.feedPlayerAndGetHungry(player, level)) {
            this.setCooldown(10);
            return;
        }
        this.setCooldown(100);
    }

    private boolean feedPlayerAndGetHungry(class_1657 player, class_1937 level) {
        int hungerLevel = 20 - player.method_7344().method_7586();
        if (hungerLevel == 0 || level.field_9236) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.method_7344().method_7586() < 20;
    }

    private boolean tryFeedingFoodFromStorage(class_1937 level, int hungerLevel, class_1657 player) {
        ItemStackHandler storage = this.getUpgradeManager().getWrapper().getStorage();
        return InventoryHelper.iterateHandler(storage, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (class_1799)stack, storage));
    }

    private boolean tryFeedingStack(class_1937 level, int hungerLevel, class_1657 player, Integer slot, class_1799 stack, ItemStackHandler backpackStorage) {
        if (FeedingUpgrade.isEdible(stack, (class_1309)player) && this.canEat(player, stack)) {
            class_1799 mainHandItem = player.method_6047();
            player.method_31548().field_7547.set(player.method_31548().field_7545, (Object)stack);
            class_1799 singleItemCopy = stack.method_7972();
            singleItemCopy.method_7939(1);
            if (singleItemCopy.method_7913(level, player, class_1268.field_5808).method_5467() == class_1269.field_21466) {
                class_1799 insertResult;
                player.method_31548().field_7547.set(player.method_31548().field_7545, (Object)mainHandItem);
                stack.method_7934(1);
                backpackStorage.setStackInSlot(slot, stack);
                class_1799 resultItem = singleItemCopy.method_7910(level, (class_1309)player);
                if (!resultItem.method_7960() && !(insertResult = InventoryHelper.addItemStackToHandler(new StorageAccessWrapper(this.getUpgradeManager().getWrapper(), backpackStorage), resultItem, false)).method_7960()) {
                    player.method_7328(insertResult, true);
                }
                return true;
            }
            player.method_31548().field_7547.set(player.method_31548().field_7545, (Object)mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(class_1799 stack, class_1309 player) {
        if (!stack.method_57826(class_9334.field_50075)) {
            return false;
        }
        class_4174 foodProperties = (class_4174)stack.method_57824(class_9334.field_50075);
        return foodProperties != null && foodProperties.comp_2491() >= 1;
    }
}

