/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_9334;

public class FeedingFilterSettings {
    public static final int ALLOW_MODE = 0;
    public static final int HUNGER_MODE = 1;
    public static final int IGNORE_EFFECT_MODE = 2;
    public static final int ALLOW = 0;
    public static final int BLOCK = 1;
    public static final int ALWAYS_EAT = 0;
    public static final int HALF_NUTRITION = 1;
    public static final int FULL_NUTRITION = 2;
    public static final int BLOCK_BAD_EFFECTS = 0;
    public static final int ALLOW_BAD_EFFECTS = 1;
    private List<class_1799> filterItems;
    private List<Integer> filterSettings;
    private ItemStackHandler storage;

    public FeedingFilterSettings(ItemStackHandler storage, List<class_1799> items, List<Integer> filterSettings) {
        this.filterItems = items;
        this.filterSettings = filterSettings;
        this.storage = storage;
    }

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean canEat(class_1702 foodData, class_1799 stack) {
        if (this.filterSettings.get(0) == 0) {
            return this.filterItems.stream().anyMatch(food -> class_1799.method_31577((class_1799)food.method_46651(1), (class_1799)stack)) && this.compareHungerLevel(foodData, stack) && this.checkHarmfulEffects(stack);
        }
        if (this.filterSettings.get(0) == 1) {
            return this.filterItems.stream().noneMatch(food -> class_1799.method_31577((class_1799)food.method_46651(1), (class_1799)stack)) && this.compareHungerLevel(foodData, stack) && this.checkHarmfulEffects(stack);
        }
        return false;
    }

    public boolean compareHungerLevel(class_1702 foodData, class_1799 stack) {
        if (this.filterSettings.get(1) == 0) {
            return foodData.method_7587();
        }
        if (this.filterSettings.get(1) == 1) {
            return this.getNutritionDifference(foodData, stack) <= this.getHalfOfStackHunger(stack);
        }
        if (this.filterSettings.get(1) == 2) {
            return this.getNutritionDifference(foodData, stack) <= 0;
        }
        return false;
    }

    public boolean checkHarmfulEffects(class_1799 stack) {
        if (this.filterSettings.get(2) == 0) {
            return this.checkHarmfulEffect((class_4174)stack.method_57824(class_9334.field_50075));
        }
        return true;
    }

    public boolean checkHarmfulEffect(class_4174 props) {
        for (class_4174.class_9423 effect : props.comp_2495()) {
            if (((class_1291)effect.comp_2496().method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
            return false;
        }
        return true;
    }

    public int getNutritionDifference(class_1702 foodData, class_1799 stack) {
        if (foodData.method_7587()) {
            class_4174 foodProps = (class_4174)stack.method_57824(class_9334.field_50075);
            int foodNutrition = foodProps.comp_2491();
            int playerNutrition = foodData.method_7586();
            return playerNutrition + foodNutrition - 20;
        }
        return 0;
    }

    public int getHalfOfStackHunger(class_1799 stack) {
        return ((class_4174)stack.method_57824(class_9334.field_50075)).comp_2491() / 2;
    }

    public void updateFilter(List<class_1799> items) {
        this.filterItems = items.stream().limit(TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount).filter(stack -> !stack.method_7960()).toList();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }
}

