/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_7225;

public class BackpackSettingsMenu
extends class_1703 {
    protected final class_1661 inventory;
    protected final BackpackWrapper wrapper;
    public int extendedScreenOffset = 0;
    public final class_1657 player;
    private class_3914 access;
    private class_2248 backpackBlock;

    public BackpackSettingsMenu(int windowID, class_1661 playerInventory, ModScreenHandlerTypes.SettingsScreenData data) {
        this(windowID, playerInventory, BackpackSettingsMenu.createWrapper(playerInventory, data));
    }

    public BackpackSettingsMenu(int windowID, class_1661 playerInventory, BackpackWrapper wrapper) {
        this((class_3917<?>)ModScreenHandlerTypes.BACKPACK_SETTINGS_MENU, windowID, playerInventory, wrapper);
        if (this.wrapper.getScreenID() == 3) {
            this.access = class_3914.method_17392((class_1937)this.player.method_37908(), (class_2338)this.getWrapper().getBackpackPos());
            this.backpackBlock = this.player.method_37908().method_8320(this.getWrapper().getBackpackPos()).method_26204();
            this.wrapper.addUser(this.inventory.field_7546);
        } else {
            this.wrapper.addUser(playerInventory.field_7546);
        }
    }

    public BackpackSettingsMenu(class_3917<?> type, int windowID, class_1661 inventory, BackpackWrapper wrapper) {
        super(type, windowID);
        this.inventory = inventory;
        this.player = inventory.field_7546;
        this.wrapper = wrapper;
        this.addSlots();
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public class_1661 getPlayerInventory() {
        return this.inventory;
    }

    public void updateSlots() {
        this.field_7764.clear();
        this.field_7761.clear();
        this.field_29206.clear();
        this.addSlots();
    }

    public void addSlots() {
        this.addBackpackStorageSlots(this.wrapper);
        this.addPlayerInventoryAndHotbar(this.inventory, this.inventory.field_7545);
    }

    public void addBackpackStorageSlots(BackpackWrapper wrapper) {
        SlotPositioner pos = wrapper.getSlotPositioner();
        int slot = 0;
        for (int i = 0; i < pos.getRows(); ++i) {
            for (int j = 0; j < pos.getSlotsInRow() && slot < wrapper.getStorage().getSlots(); ++slot, ++j) {
                this.method_7621(new BackpackSlotItemHandler(wrapper.getStorage(), slot, this.extendedScreenOffset + 8 + j * 18, 23 + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(class_1661 inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        SlotPositioner pos = this.wrapper.getSlotPositioner();
        if (pos.isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, 26 + pos.getRows() * 18 + 10 + y * 18));
            }
        }
        if (this.wrapper.getScreenID() == 1) {
            for (x = 0; x < 9; ++x) {
                if (x == currentItemIndex) {
                    this.method_7621(new DisabledSlot((class_1263)inventory, x, modifiedOffset + 8 + x * 18, pos.getRows() * 18 + 15 + 7 + 72));
                    continue;
                }
                this.method_7621(new class_1735((class_1263)inventory, x, modifiedOffset + 8 + x * 18, pos.getRows() * 18 + 15 + 7 + 72));
            }
        } else {
            for (x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x, modifiedOffset + 8 + x * 18, pos.getRows() * 18 + 15 + 7 + 72));
            }
        }
    }

    public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return false;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public void method_7595(class_1657 player) {
        class_2586 class_25862;
        class_2338 pos;
        if (!player.method_37908().field_9236 && this.getWrapper().getScreenID() == 3 && (pos = this.getWrapper().getBackpackPos()) != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)class_25862;
            backpackBlockEntity.removeSettingsUser();
        }
        if (player.field_7512 instanceof BackpackSettingsMenu && player.method_37908().field_9236) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.method_7595(player);
    }

    public boolean method_7597(class_1657 player) {
        if (this.getWrapper().getScreenID() == 3) {
            return (Boolean)this.access.method_17396((level, blockPos) -> !level.method_8320(blockPos).method_27852(this.backpackBlock) ? false : player.method_56093(blockPos, 4.0), (Object)true);
        }
        if (this.getWrapper().getBackpackOwner() != null) {
            return this.getWrapper().getBackpackOwner().method_5805() && ComponentUtils.isWearingBackpack(this.getWrapper().getBackpackOwner());
        }
        return true;
    }

    private static BackpackWrapper createWrapper(class_1661 inventory, ModScreenHandlerTypes.SettingsScreenData data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        boolean isBlockEntity = data.isBlockEntity();
        if (isBlockEntity) {
            return BackpackSettingsMenu.getBlockEntity(inventory, data);
        }
        return BackpackSettingsMenu.getWrapper(inventory, data);
    }

    private static BackpackWrapper getWrapper(class_1661 inventory, ModScreenHandlerTypes.SettingsScreenData data) {
        byte screenID = data.screenId();
        class_2338 pos = data.pos();
        if (screenID == 2) {
            return ComponentUtils.getBackpackWrapper(inventory.field_7546);
        }
        return new BackpackWrapper(inventory.field_7546.method_5998(class_1268.field_5808), screenID, (class_7225.class_7874)inventory.field_7546.method_56673(), inventory.field_7546, (class_1936)inventory.field_7546.method_37908());
    }

    private static BackpackWrapper getBlockEntity(class_1661 inventory, ModScreenHandlerTypes.SettingsScreenData data) {
        class_2338 pos = data.pos();
        class_2586 blockEntityAtPos = inventory.field_7546.method_37908().method_8321(pos);
        if (blockEntityAtPos instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntityAtPos;
            backpackBlockEntity.getWrapper().addUser(inventory.field_7546);
            backpackBlockEntity.getWrapper().setBackpackPos(pos);
            backpackBlockEntity.setSettingsUser(inventory.field_7546);
            return backpackBlockEntity.getWrapper();
        }
        throw new IllegalStateException("Block Entity is not correct! " + String.valueOf(blockEntityAtPos));
    }
}

