/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanksOld;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.item.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.item.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class BackpackWrapper {
    public static final BackpackWrapper DUMMY = new BackpackWrapper(ModItems.STANDARD_TRAVELERS_BACKPACK.method_7854(), 3, null, null, null);
    protected class_1799 stack;
    public final ItemStackHandler inventory;
    public final ItemStackHandler upgrades;
    public final ItemStackHandler tools;
    public ItemStackHandler upgradesTracker;
    private final UpgradeManager upgradeManager;
    private final SlotPositioner slotPositioner;
    private class_1657 owner;
    public ArrayList<class_1657> playersUsing = new ArrayList();
    protected class_7225.class_7874 registriesAccess;
    protected class_1936 levelAccessor;
    private final byte screenID;
    private long tanksCapacity = 0L;
    public Runnable saveHandler = () -> {};
    public Runnable abilityHandler = () -> {};
    public class_2338 backpackPos;
    public static final byte STORAGE_ID = 0;
    public static final byte UGPRADES_ID = 1;
    public static final byte TOOLS_ID = 2;

    public BackpackWrapper(class_1799 stack, byte screenID, class_7225.class_7874 registriesAccess, @Nullable class_1657 player, @Nullable class_1936 levelAccessor) {
        if (player != null) {
            this.playersUsing.add(player);
        }
        if (screenID == 2) {
            this.setBackpackOwner(player);
        }
        this.stack = stack;
        if (!BackpackWrapper.isSizeInitialized(stack)) {
            BackpackWrapper.initializeSize(stack);
        }
        int storageSlots = (Integer)stack.method_57824(ModDataComponents.STORAGE_SLOTS);
        int upgradeSlots = (Integer)stack.method_57824(ModDataComponents.UPGRADE_SLOTS);
        int toolSlots = (Integer)stack.method_57824(ModDataComponents.TOOL_SLOTS);
        this.screenID = screenID;
        this.registriesAccess = registriesAccess;
        this.levelAccessor = levelAccessor;
        this.inventory = this.createHandler(storageSlots, (byte)0);
        this.upgrades = this.createUpgradeHandler(upgradeSlots, (byte)1);
        this.tools = this.createHandler(toolSlots, (byte)2);
        this.upgradesTracker = new ItemStackHandler(this.upgrades.getSlots());
        if (registriesAccess != null) {
            this.loadInventoriesFromComponent(this.registriesAccess, this.stack);
        }
        this.slotPositioner = new SlotPositioner(storageSlots);
        this.setBackpackTankCapacity();
        this.upgradeManager = new UpgradeManager(this);
        if (!this.stack.method_57826(ModDataComponents.RENDER_INFO)) {
            this.setRenderInfo(RenderInfo.EMPTY.compoundTag());
        }
        if (stack.method_57826(ModDataComponents.STARTER_UPGRADES)) {
            List upgrades = (List)stack.method_57824(ModDataComponents.STARTER_UPGRADES);
            upgrades.forEach(this::setStarterUpgrade);
            stack.method_57381(ModDataComponents.STARTER_UPGRADES);
        }
        if (stack.method_57826(ModDataComponents.FLUID_TANKS_OLD)) {
            class_1799 oldTanks = ModItems.TANKS_UPGRADE.method_7854();
            oldTanks.method_57379(ModDataComponents.FLUIDS, (Object)new Fluids(new FluidVariantWrapper(((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).leftTank().fluidVariant(), ((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).leftTank().amount()), new FluidVariantWrapper(((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).rightTank().fluidVariant(), ((FluidTanksOld)stack.method_57824(ModDataComponents.FLUID_TANKS_OLD)).rightTank().amount())));
            this.setStarterUpgrade(oldTanks);
            stack.method_57381(ModDataComponents.FLUID_TANKS_OLD);
        }
        this.setAbilityState();
    }

    public void setBackpackStack(class_1799 backpack) {
        this.stack = backpack;
        this.getUpgradeManager().tanksUpgrade.ifPresent(tanksUpgrade -> tanksUpgrade.syncClients(backpack));
    }

    public class_1799 getBackpackStack() {
        return this.stack;
    }

    public void setBackpackOwner(class_1657 player) {
        this.owner = player;
    }

    @Nullable
    public class_1657 getBackpackOwner() {
        return this.owner;
    }

    public ArrayList<class_1657> getPlayersUsing() {
        return this.playersUsing;
    }

    public void addUser(class_1657 player) {
        if (!this.playersUsing.contains(player)) {
            this.playersUsing.add(player);
        }
    }

    public void loadInventoriesFromComponent(class_7225.class_7874 provider, class_1799 backpack) {
        BackpackContainerContents contents;
        if (backpack.method_57826(ModDataComponents.BACKPACK_CONTAINER)) {
            contents = (BackpackContainerContents)backpack.method_57824(ModDataComponents.BACKPACK_CONTAINER);
            if (contents.getItems().size() < this.getStorageSize()) {
                contents = this.expandContents(contents, this.getStorageSize(), backpack, ModDataComponents.BACKPACK_CONTAINER);
            }
            this.inventory.deserializeNBT(provider, contents.toNbt(provider));
        }
        if (backpack.method_57826(ModDataComponents.UPGRADES)) {
            contents = (BackpackContainerContents)backpack.method_57824(ModDataComponents.UPGRADES);
            if (contents.getItems().size() < this.getUpgradesSize()) {
                contents = this.expandContents(contents, this.getUpgradesSize(), backpack, ModDataComponents.UPGRADES);
            }
            this.upgrades.deserializeNBT(provider, contents.toNbt(provider));
            this.upgradesTracker.deserializeNBT(provider, contents.toNbt(provider));
        }
        if (backpack.method_57826(ModDataComponents.TOOLS_CONTAINER)) {
            contents = (BackpackContainerContents)backpack.method_57824(ModDataComponents.TOOLS_CONTAINER);
            if (contents.getItems().size() < this.getToolSize()) {
                contents = this.expandContents(contents, this.getToolSize(), backpack, ModDataComponents.TOOLS_CONTAINER);
            }
            this.tools.deserializeNBT(provider, contents.toNbt(provider));
        }
    }

    public BackpackContainerContents expandContents(BackpackContainerContents contents, int size, class_1799 backpack, class_9331 type) {
        if (contents.getItems().size() < size) {
            class_2371<class_1799> oldItems = contents.getItems();
            ArrayList<class_1799> itemList = new ArrayList<class_1799>(Collections.nCopies(size, class_1799.field_8037));
            for (int i = 0; i < oldItems.size(); ++i) {
                if (((class_1799)oldItems.get(i)).method_7960()) continue;
                itemList.set(i, (class_1799)oldItems.get(i));
            }
            BackpackContainerContents expandedContents = BackpackContainerContents.fromItems(size, itemList);
            backpack.method_57379(type, (Object)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setStarterUpgrade(class_1799 upgrade) {
        if (this.levelAccessor == null) {
            return;
        }
        if (upgrade.method_7909().method_45382(this.levelAccessor.method_45162())) {
            this.upgrades.setStackInSlot(0, upgrade);
            this.upgradesTracker.setStackInSlot(0, upgrade);
            if (upgrade.method_7909() instanceof TanksUpgradeItem) {
                this.setRenderInfo(TanksUpgradeItem.writeToRenderData().compoundTag());
            }
        }
    }

    public int getStorageSize() {
        return (Integer)this.stack.method_57825(ModDataComponents.STORAGE_SLOTS, (Object)Tiers.LEATHER.getStorageSlots());
    }

    public int getUpgradesSize() {
        return (Integer)this.stack.method_57825(ModDataComponents.UPGRADE_SLOTS, (Object)Tiers.LEATHER.getUpgradeSlots());
    }

    public int getToolSize() {
        return (Integer)this.stack.method_57825(ModDataComponents.TOOL_SLOTS, (Object)Tiers.LEATHER.getToolSlots());
    }

    public ItemStackHandler getStorage() {
        return this.inventory;
    }

    public ItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public ItemStackHandler getTools() {
        return this.tools;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public SlotPositioner getSlotPositioner() {
        return this.slotPositioner;
    }

    public class_7225.class_7874 getRegistriesAccess() {
        return this.registriesAccess;
    }

    public List<Integer> getUnsortableSlots() {
        return ((Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY)).unsortables();
    }

    public List<Pair<Integer, Pair<class_1799, Boolean>>> getMemorySlots() {
        return ((Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY)).memory();
    }

    public byte getScreenID() {
        return this.screenID;
    }

    public void setUnsortableSlots(List<Integer> unsortables) {
        Slots old = (Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY);
        this.stack.method_57379(ModDataComponents.SLOTS, (Object)Slots.updateUnsortables(old, unsortables));
        this.saveHandler.run();
    }

    public void setMemorySlots(List<Pair<Integer, Pair<class_1799, Boolean>>> memory) {
        Slots old = (Slots)this.stack.method_57825(ModDataComponents.SLOTS, (Object)Slots.EMPTY);
        this.stack.method_57379(ModDataComponents.SLOTS, (Object)Slots.updateMemory(old, memory));
        this.saveHandler.run();
    }

    public boolean showToolSlots() {
        return (Boolean)this.stack.method_57825(ModDataComponents.SHOW_TOOL_SLOTS, (Object)false);
    }

    public void setShowToolSlots(boolean show) {
        this.stack.method_57379(ModDataComponents.SHOW_TOOL_SLOTS, (Object)show);
        this.saveHandler.run();
    }

    public boolean tanksVisible() {
        if (this.stack.method_57826(ModDataComponents.RENDER_INFO)) {
            return ((RenderInfo)this.stack.method_57824(ModDataComponents.RENDER_INFO)).hasTanks();
        }
        return this.getUpgradeManager().tanksUpgrade.isPresent();
    }

    public long getBackpackTankCapacity() {
        return this.tanksCapacity;
    }

    public void setBackpackPos(class_2338 pos) {
        this.backpackPos = pos;
    }

    public class_2338 getBackpackPos() {
        return this.backpackPos;
    }

    public void setBackpackTankCapacity() {
        SlotPositioner pos = this.getSlotPositioner();
        int rows = pos.getRows() + (pos.isExtended() ? 2 : 0);
        this.tanksCapacity = Tiers.of((Integer)this.stack.method_57825(ModDataComponents.TIER, (Object)0)).getTankCapacityPerRow() * (long)rows;
    }

    public void setRenderInfo(class_2487 compound) {
        this.stack.method_57379(ModDataComponents.RENDER_INFO, (Object)new RenderInfo(compound));
        this.saveHandler.run();
    }

    public void removeRenderInfo() {
        this.stack.method_57379(ModDataComponents.RENDER_INFO, (Object)new RenderInfo(new class_2487()));
        this.saveHandler.run();
    }

    public boolean isAbilityEnabled() {
        return (Boolean)this.stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled);
    }

    public void setAbilityEnabled(boolean enabled) {
        this.stack.method_57379(ModDataComponents.ABILITY_ENABLED, (Object)enabled);
        this.saveHandler.run();
        this.abilityHandler.run();
    }

    public boolean hasSleepingBag() {
        return this.stack.method_57826(ModDataComponents.SLEEPING_BAG_COLOR);
    }

    public int getSleepingBagColor() {
        return (Integer)this.stack.method_57825(ModDataComponents.SLEEPING_BAG_COLOR, (Object)-1);
    }

    public void setSleepingBagColor(int colorId) {
        this.stack.method_57379(ModDataComponents.SLEEPING_BAG_COLOR, (Object)colorId);
    }

    public boolean isOwner(class_1657 player) {
        if (this.getBackpackOwner() != null) {
            return this.getBackpackOwner().method_5628() == player.method_5628();
        }
        return true;
    }

    public void setVisibility(boolean visibility) {
        this.stack.method_57379(ModDataComponents.IS_VISIBLE, (Object)visibility);
        this.saveHandler.run();
        this.sendDataToClients(ModDataComponents.IS_VISIBLE);
    }

    public int getCooldown() {
        return (Integer)this.stack.method_57825(ModDataComponents.COOLDOWN, (Object)0);
    }

    public void setCooldown(int cooldownInSeconds) {
        this.stack.method_57379(ModDataComponents.COOLDOWN, (Object)cooldownInSeconds);
        this.saveHandler.run();
        this.sendDataToClients(ModDataComponents.COOLDOWN);
    }

    public void decreaseCooldown() {
        if (this.getCooldown() > 0) {
            this.stack.method_57368(ModDataComponents.COOLDOWN, (Object)0, currentCooldown -> currentCooldown - 1);
            this.saveHandler.run();
        }
    }

    public void setAbilityState() {
        boolean abilityDisabled;
        boolean bl = abilityDisabled = !BackpackAbilities.isAbilityEnabledInConfig(this.getBackpackStack());
        if (abilityDisabled) {
            if (!this.getBackpackStack().method_57826(ModDataComponents.ABILITY_ENABLED)) {
                this.setAbilityEnabled(false);
                return;
            }
            if (((Boolean)this.getBackpackStack().method_57825(ModDataComponents.ABILITY_ENABLED, (Object)false)).booleanValue()) {
                this.setAbilityEnabled(false);
            }
            return;
        }
        if (!this.getBackpackStack().method_57826(ModDataComponents.ABILITY_ENABLED) && TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled) {
            this.setAbilityEnabled(true);
        }
    }

    public boolean canUpgradeTick() {
        return this.stack.method_57826(ModDataComponents.UPGRADE_TICK_INTERVAL);
    }

    public boolean hasTickingUpgrade() {
        return this.upgradeManager.hasTickingUpgrade();
    }

    public int getUpgradeTickInterval() {
        return (Integer)this.stack.method_57825(ModDataComponents.UPGRADE_TICK_INTERVAL, (Object)100);
    }

    public void setUpgradeTickInterval(int ticks) {
        this.stack.method_57379(ModDataComponents.UPGRADE_TICK_INTERVAL, (Object)ticks);
    }

    public void removeUpgradeTickInterval() {
        this.stack.method_57381(ModDataComponents.UPGRADE_TICK_INTERVAL);
    }

    public void sendDataToClients(class_9331 ... dataComponentTypes) {
        if (this.getScreenID() == 3) {
            return;
        }
        if (this.getScreenID() == 1 && !this.getPlayersUsing().stream().filter(p -> !p.method_37908().field_9236).toList().isEmpty()) {
            PacketDistributor.sendToPlayer((class_3222)this.getPlayersUsing().get(0), new ClientboundSyncItemStackPacket(this.getPlayersUsing().get(0).method_5628(), this.getScreenID() == 2 ? -1 : this.getPlayersUsing().get((int)0).method_31548().field_7545, this.getBackpackStack(), ItemStackUtils.createDataComponentMap(this.getBackpackStack(), dataComponentTypes)));
            return;
        }
        if (TravelersBackpack.enableIntegration() && this.getScreenID() == 2 && !this.getPlayersUsing().stream().filter(p -> !p.method_37908().field_9236).toList().isEmpty()) {
            for (class_1657 player : this.getPlayersUsing()) {
                PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), -1, this.getBackpackStack(), ItemStackUtils.createDataComponentMap(this.getBackpackStack(), dataComponentTypes)));
            }
            return;
        }
        if (this.getUpgradeManager().getWrapper().getBackpackOwner() != null) {
            class_9323.class_9324 mapBuilder = class_9323.method_57827();
            class_1799 serverDataHolder = ComponentUtils.getWearingBackpack(this.getUpgradeManager().getWrapper().getBackpackOwner()).method_7972();
            for (class_9331 type : dataComponentTypes) {
                class_1799 serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
                if (!serverDataHolderCopy.method_57826(type)) continue;
                mapBuilder.method_57840(type, serverDataHolderCopy.method_57824(type));
            }
            ComponentUtils.getComponent(this.getUpgradeManager().getWrapper().getBackpackOwner()).ifPresent(data -> data.synchronise(mapBuilder.method_57838()));
        }
    }

    public Optional<Pair<Integer, Pair<class_1799, Boolean>>> getMemorizedSlot(int slot) {
        return this.getMemorySlots().stream().filter(pair -> (Integer)pair.getFirst() == slot).findFirst();
    }

    private ItemStackHandler createHandler(int size, final byte dataId) {
        return new ItemStackHandler(this, size){
            final /* synthetic */ BackpackWrapper this$0;
            {
                this.this$0 = this$0;
                super(size);
            }

            @Override
            protected void onContentsChanged(int slot) {
                this.this$0.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (dataId == 2) {
                    this.this$0.sendDataToClients(ModDataComponents.TOOLS_CONTAINER);
                }
                this.this$0.saveHandler.run();
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                if (dataId == 2) {
                    return ToolSlotItemHandler.isValid(stack);
                }
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }

    public void setSlotChanged(int index, class_1799 stack, byte dataId) {
        switch (dataId) {
            case 0: {
                this.stack.method_57367(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(this.getStorage().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 1: {
                this.stack.method_57367(ModDataComponents.UPGRADES, (Object)new BackpackContainerContents(this.getUpgrades().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 2: {
                this.stack.method_57367(ModDataComponents.TOOLS_CONTAINER, (Object)new BackpackContainerContents(this.getTools().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
            }
        }
    }

    public void updateMinimalTickInterval(class_1799 newStack) {
        if (this.getScreenID() == 2 && (newStack.method_7909() == ModItems.FEEDING_UPGRADE || newStack.method_7909() == ModItems.MAGNET_UPGRADE)) {
            if (((Boolean)newStack.method_57825(ModDataComponents.UPGRADE_ENABLED, (Object)true)).booleanValue()) {
                int minimalInterval = 100;
                for (int i = 0; i < this.upgrades.getSlots(); ++i) {
                    class_1799 upgrade = this.upgrades.getStackInSlot(i);
                    if (!upgrade.method_57826(ModDataComponents.COOLDOWN)) continue;
                    minimalInterval = Math.min(minimalInterval, (Integer)upgrade.method_57824(ModDataComponents.COOLDOWN));
                }
                if (!this.canUpgradeTick() || this.getUpgradeTickInterval() != minimalInterval) {
                    this.setUpgradeTickInterval(minimalInterval);
                }
            } else if (this.canUpgradeTick() && !this.hasTickingUpgrade()) {
                this.removeUpgradeTickInterval();
            }
        }
    }

    private ItemStackHandler createUpgradeHandler(int size, final byte dataId) {
        return new ItemStackHandler(this, size){
            final /* synthetic */ BackpackWrapper this$0;
            {
                this.this$0 = this$0;
                super(size);
            }

            @Override
            protected void onContentsChanged(int slot) {
                this.this$0.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (!this.this$0.getPlayersUsing().isEmpty()) {
                    this.this$0.getUpgradeManager().detectedChange(this.this$0.upgradesTracker, slot);
                }
                this.this$0.updateMinimalTickInterval(this.getStackInSlot(slot));
                this.this$0.saveHandler.run();
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                boolean isValid = true;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).method_7909() != stack.method_7909()) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                if (stack.method_7909() instanceof TanksUpgradeItem) {
                    isValid = TanksUpgradeItem.canBePutInBackpack(this.this$0.getBackpackTankCapacity(), stack);
                }
                if (!this.checkIfUpgradeValid(stack)) {
                    isValid = false;
                }
                return isValid;
            }

            public boolean checkIfUpgradeValid(class_1799 upgradeStack) {
                class_1792 class_17922 = upgradeStack.method_7909();
                if (class_17922 instanceof UpgradeItem) {
                    class_1657 player;
                    UpgradeItem upgradeItem = (UpgradeItem)class_17922;
                    class_1657 class_16572 = player = this.this$0.getPlayersUsing().isEmpty() ? null : this.this$0.getPlayersUsing().getFirst();
                    if (player == null) {
                        return false;
                    }
                    if (upgradeItem.method_45382(player.method_37908().method_45162())) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static boolean isSizeInitialized(class_1799 stack) {
        return stack.method_57826(ModDataComponents.STORAGE_SLOTS) && stack.method_57826(ModDataComponents.UPGRADE_SLOTS) && stack.method_57826(ModDataComponents.TOOL_SLOTS);
    }

    public static void initializeSize(class_1799 stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        if (stack.method_57826(ModDataComponents.TIER)) {
            tier = Tiers.of((Integer)stack.method_57824(ModDataComponents.TIER));
        }
        if (!stack.method_57826(ModDataComponents.STORAGE_SLOTS)) {
            stack.method_57379(ModDataComponents.STORAGE_SLOTS, (Object)tier.getStorageSlots());
        }
        if (!stack.method_57826(ModDataComponents.UPGRADE_SLOTS)) {
            stack.method_57379(ModDataComponents.UPGRADE_SLOTS, (Object)tier.getUpgradeSlots());
        }
        if (!stack.method_57826(ModDataComponents.TOOL_SLOTS)) {
            stack.method_57379(ModDataComponents.TOOL_SLOTS, (Object)tier.getToolSlots());
        }
    }

    public void requestMenuAndScreenUpdate(boolean onlyTab) {
        this.requestMenuUpdate(onlyTab);
        this.requestScreenUpdate();
    }

    public void requestMenuUpdate(boolean onlyTab) {
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.field_7512 instanceof BackpackBaseMenu).toList().isEmpty()) {
            for (class_1657 player2 : this.getPlayersUsing().stream().filter(player -> player.field_7512 instanceof BackpackBaseMenu).toList()) {
                if (onlyTab) {
                    ((BackpackBaseMenu)player2.field_7512).updateModifiableSlots();
                    continue;
                }
                ((BackpackBaseMenu)player2.field_7512).updateSlots();
            }
        }
    }

    public void requestScreenUpdate() {
        class_437 class_4372;
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.method_37908().field_9236).toList().isEmpty() && (class_4372 = class_310.method_1551().field_1755) instanceof BackpackScreen) {
            BackpackScreen screen = (BackpackScreen)class_4372;
            screen.updateScreen(false);
        }
    }

    public static void tickForBlockEntity(BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
        if (wrapper != DUMMY && wrapper.isAbilityEnabled() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, wrapper.getBackpackStack())) {
            boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickBlock(backpackBlockEntity);
            if (wrapper.getCooldown() > 0 && decreaseCooldown) {
                wrapper.decreaseCooldown();
            }
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 backpack) {
        if (ComponentUtils.isWearingBackpack(player)) {
            BackpackItemMenu menu;
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof BackpackItemMenu && (menu = (BackpackItemMenu)class_17032).getWrapper().getScreenID() == 2) {
                return menu.getWrapper();
            }
            for (class_1657 otherPlayer : player.method_37908().method_18456()) {
                BackpackItemMenu menu2;
                class_1703 class_17033 = otherPlayer.field_7512;
                if (!(class_17033 instanceof BackpackItemMenu) || !(menu2 = (BackpackItemMenu)class_17033).getWrapper().isOwner(player) || menu2.getWrapper().getScreenID() != 2) continue;
                return menu2.getWrapper();
            }
            return new BackpackWrapper(backpack, 2, (class_7225.class_7874)player.method_37908().method_30349(), player, (class_1936)player.method_37908());
        }
        return null;
    }

    public static void tick(class_1799 stack, class_1657 player, boolean integration) {
        if (!integration && TravelersBackpack.enableIntegration()) {
            return;
        }
        if (player.method_5805() && ComponentUtils.isWearingBackpack(player)) {
            int upgradeTicks;
            BackpackWrapper wrapper;
            int ticks = (int)player.method_37908().method_8510();
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
                if (BackpackAbilities.isAbilityEnabledInConfig(stack) && ((Boolean)stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled)).booleanValue()) {
                    boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTick(stack, player);
                    if ((Integer)stack.method_57825(ModDataComponents.COOLDOWN, (Object)0) > 0 && ticks % 100 == 0 && decreaseCooldown) {
                        wrapper = ComponentUtils.getBackpackWrapper(player, stack);
                        int cooldown = wrapper.getCooldown();
                        if (player.method_37908().field_9236) {
                            return;
                        }
                        wrapper.setCooldown(cooldown - 100);
                    }
                }
            } else if (((Boolean)stack.method_57825(ModDataComponents.ABILITY_ENABLED, (Object)false)).booleanValue()) {
                stack.method_57379(ModDataComponents.ABILITY_ENABLED, (Object)false);
            }
            if (stack.method_57826(ModDataComponents.UPGRADE_TICK_INTERVAL) && ticks % (upgradeTicks = ((Integer)stack.method_57824(ModDataComponents.UPGRADE_TICK_INTERVAL)).intValue()) == 0) {
                wrapper = ComponentUtils.getBackpackWrapper(player, stack);
                for (int i = 0; i < wrapper.getUpgradeManager().mappedUpgrades.size(); ++i) {
                    Optional<? extends IUpgrade> upgrade = wrapper.getUpgradeManager().mappedUpgrades.get(i);
                    if (upgrade == null || !upgrade.isPresent() || !(upgrade.get() instanceof ITickableUpgrade)) continue;
                    ((ITickableUpgrade)((Object)upgrade.get())).tick(player, player.method_37908(), player.method_24515(), ticks);
                }
            }
        }
    }
}

