/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.component;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.component.ITravelersBackpack;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9323;
import org.ladysnake.cca.api.v3.component.ComponentProvider;

public class TravelersBackpackComponent
implements ITravelersBackpack {
    private final String BACKPACK = "Wearable";
    public final class_1657 player;
    public BackpackWrapper backpackWrapper;
    public class_1799 backpack = new class_1799((class_1935)class_1802.field_8162, 0);

    public TravelersBackpackComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.method_7909() instanceof TravelersBackpackItem;
    }

    @Override
    public class_1799 getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(class_1799 stack) {
        this.remove();
        if (!(stack.method_7909() instanceof TravelersBackpackItem)) {
            return;
        }
        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, 2, (class_7225.class_7874)this.player.method_56673(), this.player, (class_1936)this.player.method_37908());
        this.backpackWrapper.setBackpackOwner(this.player);
        this.synchronise();
    }

    @Override
    public void updateBackpack(class_1799 stack) {
        if (this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);
        } else {
            this.equipBackpack(stack);
        }
    }

    @Override
    public void applyComponents(class_9323 map) {
        if (this.backpackWrapper != null) {
            this.backpack.method_57365(map);
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeWearable() {
        this.backpack = new class_1799((class_1935)class_1802.field_8162, 0);
    }

    @Override
    public void removeWrapper() {
        if (this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove() {
        this.removeWearable();
        this.removeWrapper();
        if (this.player.method_37908() != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync((Object)this.player, (buf, recipient) -> this.writeSyncPacket(this.getBackpack(), buf, recipient, true));
            for (class_3222 recipient2 : PlayerLookup.tracking((class_1297)this.player)) {
                if (recipient2.method_5628() == this.player.method_5628()) continue;
                ComponentUtils.WEARABLE.syncWith(recipient2, (ComponentProvider)this.player, (buf, rec) -> this.writeSyncPacket(this.getBackpack(), buf, rec, true), p -> true);
            }
        }
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise() {
        if (this.player != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync((Object)this.player);
            for (class_3222 recipient : PlayerLookup.tracking((class_1297)this.player)) {
                if (recipient.method_5628() == this.player.method_5628()) continue;
                ComponentUtils.WEARABLE.syncWith(recipient, (ComponentProvider)this.player, (buf, rec) -> this.writeSyncPacket(buf, rec), p -> true);
            }
        }
    }

    @Override
    public void synchronise(class_9323 map) {
        if (this.player != null && !this.player.method_37908().field_9236) {
            ComponentUtils.WEARABLE.sync((Object)this.player, (buf, recipient) -> this.writeComponentPacket(buf, recipient, map));
            for (class_3222 recipient2 : PlayerLookup.tracking((class_1297)this.player)) {
                if (recipient2.method_5628() == this.player.method_5628()) continue;
                ComponentUtils.WEARABLE.syncWith(recipient2, (ComponentProvider)this.player, (buf, rec) -> this.writeComponentPacket(buf, rec, map), p -> true);
            }
        }
    }

    public void readFromNbt(class_2487 compoundTag, class_7225.class_7874 registryLookup) {
        class_1799 backpack = class_1799.method_57359((class_7225.class_7874)registryLookup, (class_2487)compoundTag.method_10562("Wearable"));
        this.equipBackpack(backpack);
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2487 compound = new class_2487();
        if (this.hasBackpack()) {
            class_1799 backpack = this.getBackpack();
            compound = (class_2487)backpack.method_57375(registryLookup);
        }
        tag.method_10566("Wearable", (class_2520)compound);
    }

    public void writeComponentPacket(class_9129 buf, class_3222 recipient, class_9323 map) {
        buf.method_53002(1);
        class_9135.method_56896((Codec)class_9323.field_50234).encode((Object)buf, (Object)map);
    }

    public void writeSyncPacket(class_1799 backpack, class_9129 buf, class_3222 recipient, boolean removeData) {
        class_1799 backpackCopy = backpack.method_7972();
        if (backpackCopy.method_57826(ModDataComponents.BACKPACK_CONTAINER)) {
            backpackCopy.method_57381(ModDataComponents.BACKPACK_CONTAINER);
        }
        if (backpackCopy.method_57826(ModDataComponents.SLOTS)) {
            Slots slots = (Slots)backpackCopy.method_57824(ModDataComponents.SLOTS);
            List<Pair<Integer, Pair<class_1799, Boolean>>> memorizedStacksHeavy = slots.memory();
            ArrayList<Pair<Integer, Pair<class_1799, Boolean>>> reduced = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>();
            for (Pair<Integer, Pair<class_1799, Boolean>> outerPair : memorizedStacksHeavy) {
                int index = (Integer)outerPair.getFirst();
                class_1799 innerStack = ((class_1799)((Pair)outerPair.getSecond()).getFirst()).method_7972();
                boolean matchComponents = (Boolean)((Pair)outerPair.getSecond()).getSecond();
                if (matchComponents) {
                    innerStack = new class_1799((class_1935)innerStack.method_7909(), innerStack.method_7947());
                }
                if (innerStack.method_7960()) continue;
                reduced.add((Pair<Integer, Pair<class_1799, Boolean>>)Pair.of((Object)index, (Object)Pair.of((Object)innerStack, (Object)matchComponents)));
            }
            backpackCopy.method_57379(ModDataComponents.SLOTS, (Object)new Slots(slots.unsortables(), reduced));
        }
        buf.method_53002(0);
        buf.method_52964(removeData);
        class_1799.field_49268.encode((Object)buf, (Object)backpackCopy);
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        this.writeSyncPacket(this.getBackpack(), buf, recipient, false);
    }

    public void applySyncPacket(class_9129 buf) {
        int type = buf.readInt();
        if (type == 0) {
            boolean removeData = buf.readBoolean();
            class_1799 backpackStack = (class_1799)class_1799.field_49268.decode((Object)buf);
            if (removeData) {
                this.remove();
            } else {
                this.updateBackpack(backpackStack);
            }
        } else {
            class_9323 map = (class_9323)class_9135.method_56896((Codec)class_9323.field_50234).decode((Object)buf);
            if (map != null) {
                this.applyComponents(map);
            }
        }
    }
}

