/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.rei;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundTabPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_1703;
import net.minecraft.class_1735;

public class ReiClientCompat
implements REIClientPlugin {
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)new BackpackTransferHandler());
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(BackpackSettingsScreen.class, screen -> {
            ArrayList ret = new ArrayList();
            screen.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(widget -> {
                int[] size = ((WidgetBase)widget).getWidgetSizeAndPos();
                ret.add(new Rectangle(size[0], size[1], size[2], size[3]));
            });
            return ret;
        });
        zones.register(BackpackScreen.class, screen -> {
            ArrayList<Rectangle> ret = new ArrayList<Rectangle>();
            int[] s = screen.settingsWidget.getWidgetSizeAndPos();
            ret.add(new Rectangle(s[0], s[1], s[2], s[3]));
            screen.method_25396().stream().filter(w -> w instanceof UpgradeWidgetBase).forEach(widget -> {
                int[] size = ((UpgradeWidgetBase)widget).getWidgetSizeAndPos();
                ret.add(new Rectangle(size[0], size[1], size[2], size[3]));
            });
            screen.upgradeSlots.forEach(slot -> {
                if (!slot.isHidden()) {
                    int[] size = slot.getUpgradeSlotSizeAndPos();
                    ret.add(new Rectangle(size[0], size[1], size[2], size[3]));
                }
            });
            return ret;
        });
    }

    public static class BackpackTransferHandler
    implements SimpleTransferHandler {
        public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
            if (!BackpackBaseMenu.class.isInstance(context.getMenu()) || !BuiltinPlugin.CRAFTING.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                return TransferHandler.ApplicabilityResult.createNotApplicable();
            }
            class_1703 class_17032 = context.getMenu();
            if (class_17032 instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
                if (menu.getWrapper().getUpgradeManager().craftingUpgrade.isPresent()) {
                    return TransferHandler.ApplicabilityResult.createApplicable();
                }
            }
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }

        public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
            class_1703 class_17032 = context.getMenu();
            if (class_17032 instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
                return IntStream.range(menu.CRAFTING_GRID_START, menu.CRAFTING_GRID_START + 9).mapToObj(id -> SlotAccessor.fromSlot((class_1735)context.getMenu().method_7611(id))).toList();
            }
            return List.of();
        }

        public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
            class_1703 class_17032 = context.getMenu();
            if (class_17032 instanceof BackpackBaseMenu) {
                int i;
                BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
                ArrayList<SlotAccessor> list = new ArrayList<SlotAccessor>();
                for (i = 0; i < menu.BACKPACK_INV_END; ++i) {
                    list.add(SlotAccessor.fromSlot((class_1735)menu.method_7611(i)));
                }
                for (i = menu.PLAYER_INV_START; i < menu.PLAYER_HOT_END; ++i) {
                    if (menu.getWrapper().getScreenID() == 1 && menu.method_7611(i) instanceof DisabledSlot) continue;
                    list.add(SlotAccessor.fromSlot((class_1735)menu.method_7611(i)));
                }
                return list;
            }
            return List.of();
        }

        public TransferHandler.Result handle(TransferHandler.Context context) {
            class_1703 class_17032 = context.getMenu();
            if (class_17032 instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
                CraftingUpgrade upgrade = menu.getWrapper().getUpgradeManager().craftingUpgrade.get();
                if (!upgrade.isTabOpened() && context.isActuallyCrafting()) {
                    PacketDistributor.sendToServer(new ServerboundTabPacket(upgrade.getDataHolderSlot(), true, 0));
                }
            }
            return this.handleSimpleTransfer(context, this.getMissingInputRenderer(), this.getInputsIndexed(context), this.getInputSlots(context), this.getInventorySlots(context));
        }
    }
}

