/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8060;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9697;

public class BackpackUpgradeRecipe
extends class_8060 {
    final class_1856 template;
    final class_1856 base;
    final class_1856 addition;
    final class_1799 result;

    public BackpackUpgradeRecipe(class_1856 pTemplate, class_1856 pBase, class_1856 pAddition, class_1799 pResult) {
        super(pTemplate, pBase, pAddition, pResult);
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public class_1799 method_60000(class_9697 pInput, class_7225.class_7874 pRegistries) {
        class_1799 result = pInput.method_59984(1).method_56701((class_1935)this.result.method_7909(), this.result.method_7947());
        result.method_57366(this.result.method_57380());
        class_1799 base = pInput.method_59984(1);
        class_1799 addition = pInput.method_59984(2);
        int tier = (Integer)base.method_57825(ModDataComponents.TIER, (Object)0);
        if (addition.method_31574(Tiers.of(tier).getTierUpgradeIngredient())) {
            this.upgradeInventory(result, Tiers.of(tier).getNextTier());
            return result;
        }
        return class_1799.field_8037;
    }

    public void upgradeInventory(class_1799 stack, Tiers.Tier nextTier) {
        stack.method_57379(ModDataComponents.TIER, (Object)nextTier.getOrdinal());
        stack.method_57379(ModDataComponents.STORAGE_SLOTS, (Object)nextTier.getStorageSlots());
        stack.method_57379(ModDataComponents.UPGRADE_SLOTS, (Object)nextTier.getUpgradeSlots());
        stack.method_57379(ModDataComponents.TOOL_SLOTS, (Object)nextTier.getToolSlots());
        if (stack.method_57826(ModDataComponents.RENDER_INFO)) {
            stack.method_57379(ModDataComponents.RENDER_INFO, (Object)this.getUpgradedTanksCapacity(stack, nextTier.getStorageSlots()));
        }
    }

    public RenderInfo getUpgradedTanksCapacity(class_1799 stack, int storageSlots) {
        SlotPositioner pos = new SlotPositioner(storageSlots);
        int rows = pos.getRows() + (pos.isExtended() ? 2 : 0);
        class_2487 infoTag = ((RenderInfo)stack.method_57824(ModDataComponents.RENDER_INFO)).compoundTag().method_10553();
        RenderInfo newInfo = new RenderInfo(infoTag);
        newInfo.updateCapacity(Tiers.of((Integer)stack.method_57825(ModDataComponents.TIER, (Object)0)).getTankCapacityPerRow() * (long)rows);
        return newInfo;
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_UPGRADE;
    }

    public static class Serializer
    implements class_1865<BackpackUpgradeRecipe> {
        private static final MapCodec<BackpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340782_ -> p_340782_.group((App)class_1856.field_46095.fieldOf("template").forGetter(p_301310_ -> p_301310_.template), (App)class_1856.field_46095.fieldOf("base").forGetter(p_300938_ -> p_300938_.base), (App)class_1856.field_46095.fieldOf("addition").forGetter(p_301153_ -> p_301153_.addition), (App)class_1799.field_51397.fieldOf("result").forGetter(p_300935_ -> p_300935_.result)).apply((Applicative)p_340782_, BackpackUpgradeRecipe::new));
        public static final class_9139<class_9129, BackpackUpgradeRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BackpackUpgradeRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BackpackUpgradeRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static BackpackUpgradeRecipe fromNetwork(class_9129 p_320375_) {
            class_1856 ingredient = (class_1856)class_1856.field_48355.decode((Object)p_320375_);
            class_1856 ingredient1 = (class_1856)class_1856.field_48355.decode((Object)p_320375_);
            class_1856 ingredient2 = (class_1856)class_1856.field_48355.decode((Object)p_320375_);
            class_1799 itemstack = (class_1799)class_1799.field_48349.decode((Object)p_320375_);
            return new BackpackUpgradeRecipe(ingredient, ingredient1, ingredient2, itemstack);
        }

        private static void toNetwork(class_9129 p_320743_, BackpackUpgradeRecipe p_319840_) {
            class_1856.field_48355.encode((Object)p_320743_, (Object)p_319840_.template);
            class_1856.field_48355.encode((Object)p_320743_, (Object)p_319840_.base);
            class_1856.field_48355.encode((Object)p_320743_, (Object)p_319840_.addition);
            class_1799.field_48349.encode((Object)p_320743_, (Object)p_319840_.result);
        }
    }
}

