/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.network.ServerboundRemoveUpgradePacket;
import com.tiviacz.travelersbackpack.network.ServerboundTabPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class UpgradeWidgetBase<U extends UpgradeBase>
extends WidgetBase<BackpackScreen> {
    private final WidgetElement removeElement;
    private final WidgetElement enableElement;
    protected U upgrade;
    protected int dataHolderSlot;
    private final Point tabUv;
    private final String upgradeIconTooltip;

    public UpgradeWidgetBase(BackpackScreen screen, U upgrade, Point pos, Point tabUv, String upgradeIconTooltip) {
        super(screen, pos, 24, 24);
        this.upgrade = upgrade;
        this.dataHolderSlot = ((UpgradeBase)upgrade).getDataHolderSlot();
        this.tabUv = tabUv;
        this.upgradeIconTooltip = upgradeIconTooltip;
        this.width = ((UpgradeBase)upgrade).getTabSize().x();
        this.height = ((UpgradeBase)upgrade).getTabSize().y();
        this.removeElement = new WidgetElement(new Point(((UpgradeBase)this.upgrade).getTabSize().x() - 3 - 18, 3), new Point(18, 18));
        this.enableElement = new WidgetElement(new Point(((UpgradeBase)this.upgrade).getTabSize().x(), 6), new Point(4, 13));
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isTabOpened()) {
            U u = this.upgrade;
            if (u instanceof IFilter) {
                IFilter filter = (IFilter)u;
                int slotCount = filter.getFilterSlotCount();
                int rowCount = (int)Math.ceil((double)slotCount / 3.0);
                guiGraphics.method_25302(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.tabUv.x(), this.tabUv.y(), this.width, 43);
                guiGraphics.method_25302(BackpackScreen.TABS, this.pos.x(), this.pos.y() + 43, this.tabUv.x(), this.tabUv.y() + 43 + (3 - rowCount) * 18, this.width, this.height - 43);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (j + i * 3 >= slotCount) continue;
                        guiGraphics.method_25302(BackpackScreen.TABS, this.pos.x() + 6 + j * 18, this.pos.y() + 43 + i * 18, 233, 0, 18, 18);
                    }
                }
            } else {
                guiGraphics.method_25302(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.tabUv.x(), this.tabUv.y(), this.width, this.height);
            }
            guiGraphics.method_51427(((BackpackScreen)this.screen).getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), this.pos.x() + 4, this.pos.y() + 4);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderEnableButton(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isBackpackOwner()) {
            this.renderRemoveButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOverIcon(mouseX, mouseY)) {
            guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), (class_2561)class_2561.method_43471((String)this.upgradeIconTooltip), mouseX, mouseY);
        }
        this.renderEnableButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.enableButtonMouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.removeButtonMouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            if (((UpgradeBase)this.upgrade).isTabOpened()) {
                PacketDistributor.sendToServer(new ServerboundTabPacket(this.dataHolderSlot, false, 0));
            } else {
                PacketDistributor.sendToServer(new ServerboundTabPacket(this.dataHolderSlot, true, 0));
            }
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25405(double pMouseX, double pMouseY) {
        return pMouseX > (double)(this.pos.x() + 3) && pMouseY > (double)this.pos.y() && pMouseX < (double)(this.pos.x() + ((UpgradeBase)this.upgrade).getTabSize().x()) && pMouseY < (double)(this.pos.y() + ((UpgradeBase)this.upgrade).getTabSize().y());
    }

    public boolean isMouseOverRemoveButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.removeElement);
    }

    public boolean isMouseOverEnableButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.enableElement);
    }

    public void renderMatchContentsSlotOverlay(class_332 guiGraphics, List<Integer> filter, int settingType, int settingValue, int activeSlots) {
        if (this.isTabOpened() && filter.get(settingType) == settingValue) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (j + i * 3 >= activeSlots) continue;
                    guiGraphics.method_25302(BackpackScreen.ICONS, this.pos.x() + 6 + 18 * j, this.pos.y() + 43 + 18 * i, 24, 36, 18, 18);
                }
            }
        }
    }

    public void renderRemoveButton(class_332 guiGraphics, double mouseX, double mouseY) {
        if (this.isTabOpened()) {
            guiGraphics.method_25302(BackpackScreen.ICONS, this.pos.x() + this.removeElement.pos().x(), this.pos.y() + this.removeElement.pos().y(), 42, 36, this.removeElement.size().x(), this.removeElement.size().y());
        }
    }

    public boolean removeButtonMouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverRemoveButton(pMouseX, pMouseY)) {
            if (!this.isBackpackOwner()) {
                return false;
            }
            PacketDistributor.sendToServer(new ServerboundRemoveUpgradePacket(this.dataHolderSlot));
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    public void renderEnableButton(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened()) {
                if (e.isEnabled()) {
                    guiGraphics.method_25302(BackpackScreen.ICONS, this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y(), 18, 24, this.enableElement.size().x(), this.enableElement.size().y());
                    if (this.isMouseOverEnableButton(mouseX, mouseY)) {
                        guiGraphics.method_51740(class_1921.method_51785(), this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y() + 7, this.pos.x() + this.enableElement.pos().x() + 3, this.pos.y() + this.enableElement.pos().y() + 12, -2130706433, -2130706433, 0);
                    }
                } else {
                    guiGraphics.method_25302(BackpackScreen.ICONS, this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y(), 18, 37, this.enableElement.size().x(), this.enableElement.size().y());
                    if (this.isMouseOverEnableButton(mouseX, mouseY)) {
                        guiGraphics.method_51740(class_1921.method_51785(), this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y() + 1, this.pos.x() + this.enableElement.pos().x() + 3, this.pos.y() + this.enableElement.pos().y() + 6, -2130706433, -2130706433, 0);
                    }
                }
            }
        }
    }

    public void renderEnableButtonTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverEnableButton(mouseX, mouseY)) {
                if (e.isEnabled()) {
                    guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), (class_2561)class_2561.method_43470((String)"Disable Upgrade"), mouseX, mouseY);
                } else {
                    guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), (class_2561)class_2561.method_43470((String)"Enable Upgrade"), mouseX, mouseY);
                }
            }
        }
    }

    public boolean enableButtonMouseClicked(double pMouseX, double pMouseY, int pButton) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverEnableButton(pMouseX, pMouseY)) {
                if (!this.isBackpackOwner()) {
                    return false;
                }
                PacketDistributor.sendToServer(new ServerboundTabPacket(this.dataHolderSlot, !e.isEnabled(), 1));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return false;
    }

    public boolean isBackpackOwner() {
        return ((BackpackScreen)this.screen).getWrapper().isOwner(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).player);
    }

    public boolean isTabOpened() {
        return ((UpgradeBase)this.upgrade).isTabOpened();
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.pos.x(), this.pos.y(), this.width + (this.upgrade instanceof IEnable && !this.isTabOpened() ? 4 : 0), this.height};
        return size;
    }
}

