/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClientBackpackTooltipComponent
implements class_5684 {
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public int method_32661() {
        int height = 0;
        if (BackpackDeathHelper.isCtrlPressed()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.storage.isEmpty()) {
                height += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                height += 18;
            }
        }
        return height;
    }

    public int method_32664(class_327 font) {
        int width = 0;
        if (BackpackDeathHelper.isCtrlPressed() && !this.component.storage.isEmpty()) {
            width += Math.min(this.component.storage.size(), 9) * 18 + Math.min(this.component.storage.size(), 9) * 2;
        }
        return width;
    }

    public void method_32665(class_327 pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, class_4597.class_4598 pBufferSource) {
        if (BackpackDeathHelper.isCtrlPressed()) {
            int yOffset = 0;
            if (!this.component.leftFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.leftFluidStack, pFont, pMouseX, pMouseY, pMatrix, (class_4597)pBufferSource);
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.rightFluidStack, pFont, pMouseX, pMouseY + yOffset, pMatrix, (class_4597)pBufferSource);
            }
        }
    }

    public void renderFluidTankTooltip(FluidVariantWrapper fluidStack, class_327 font, int mouseX, int mouseY, Matrix4f matrix, class_4597 bufferSource) {
        class_2561 c = FluidTypeHelper.getFluidVariantName(fluidStack.fluidVariant());
        class_5250 c1 = class_2561.method_43470((String)": ");
        class_5250 c2 = class_2561.method_43470((String)(fluidStack.getAmount() + "mB"));
        font.method_30882(c, (float)mouseX, (float)mouseY, -1, true, matrix, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_30882((class_2561)c1, (float)mouseX + (float)font.method_27525((class_5348)c), (float)mouseY, -1, true, matrix, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_30882((class_2561)c2, (float)mouseX + (float)font.method_27525((class_5348)c) + (float)font.method_27525((class_5348)c1), (float)mouseY, 0x5555FF, true, matrix, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public void method_32666(class_327 pFont, int pX, int pY, class_332 pGuiGraphics) {
        int yOffset = 0;
        if (BackpackDeathHelper.isCtrlPressed()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                yOffset += 10;
            }
            boolean flag = false;
            if (!this.component.storage.isEmpty()) {
                int j = 0;
                flag = true;
                for (int i = 0; i < this.component.storage.size(); ++i) {
                    this.renderItem(this.component.storage.get(i), pX + j * 2 + j * 18, pY + yOffset, pFont, pGuiGraphics);
                    if (j < 8) {
                        ++j;
                        continue;
                    }
                    j = 0;
                    yOffset += 18;
                }
            }
            if (!this.component.tools.isEmpty()) {
                if (flag) {
                    yOffset += 18;
                }
                for (int i = 0; i < this.component.tools.size(); ++i) {
                    this.renderItem(this.component.tools.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
        }
    }

    private void renderItem(class_1799 stack, int pX, int pY, class_327 pFont, class_332 guiGraphics) {
        guiGraphics.method_51445(stack, pX, pY);
        guiGraphics.method_51431(pFont, stack, pX, pY);
    }
}

