/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class AbilitySliderButton
extends Button {
    private final WidgetElement abilitySliderElement = new WidgetElement(new Point(133, -95), new Point(18, 11));
    private final boolean isBlock;

    public AbilitySliderButton(BackpackScreen screen, boolean isBlock) {
        super(screen, screen.getWidthAdditions() + 133, screen.getImageHeight() - 95, 18, 11);
        this.isBlock = isBlock;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isBlock) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        } else if (ComponentUtils.isWearingBackpack(((BackpackBaseMenu)this.screen.method_17577()).getPlayerInventory().field_7546)) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        }
    }

    public void drawButton(class_332 guiGraphics, int mouseX, int mouseY, class_2960 texture) {
        if (this.screen.getWrapper().isAbilityEnabled()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 42, 54, 42, 76);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 42, 65, 42, 76);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.inButton(mouseX, mouseY)) {
            if (this.screen.getWrapper().isAbilityEnabled()) {
                ArrayList<class_5481> list = new ArrayList<class_5481>();
                list.add(class_2561.method_43471((String)"screen.travelersbackpack.ability_enabled").method_30937());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack())) {
                    list.add(this.screen.getWrapper().getCooldown() == 0 ? class_2561.method_43471((String)"screen.travelersbackpack.ability_ready").method_30937() : class_2561.method_43471((String)BackpackDeathHelper.getConvertedTime(this.screen.getWrapper().getCooldown())).method_30937());
                }
                guiGraphics.method_51447(this.screen.getFont(), list, mouseX, mouseY);
            } else if (!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !TravelersBackpackConfig.isAbilityAllowed(this.screen.getWrapper().getBackpackStack())) {
                guiGraphics.method_51438(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                guiGraphics.method_51438(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.isAbilityEnabledInConfig(this.screen.getWrapper().getBackpackStack())) {
            return false;
        }
        if (this.isBlock) {
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
                PacketDistributor.sendToServer(new ServerboundAbilitySliderPacket(this.screen.getWrapper().getScreenID(), !this.screen.getWrapper().isAbilityEnabled()));
                this.screen.playUIClickSound();
                return true;
            }
        } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
            PacketDistributor.sendToServer(new ServerboundAbilitySliderPacket(this.screen.getWrapper().getScreenID(), !this.screen.getWrapper().isAbilityEnabled()));
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

