/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.TravelersBackpackClient;
import com.tiviacz.travelersbackpack.client.model.BackpackBlockModel;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class BackpackLayer
extends class_3887<class_742, class_591<class_742>> {
    private static final class_5819 RANDOM = class_5819.method_43049((long)42L);

    public BackpackLayer(class_3883<class_742, class_591<class_742>> renderer) {
        super(renderer);
    }

    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_742 clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        if (ComponentUtils.isWearingBackpack((class_1657)clientPlayer)) {
            class_1799 stack = ComponentUtils.getWearingBackpack((class_1657)clientPlayer);
            BackpackLayer.renderBackpackLayer(BackpackLayerModel.LAYER_MODEL, (class_572)this.method_17165(), poseStack, bufferIn, packedLightIn, (class_1309)clientPlayer, stack);
        }
    }

    public static void renderBackpackLayer(BackpackLayerModel model, class_572 humanoidModel, class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1309 entity, class_1799 stack) {
        if (!((Boolean)stack.method_57825(ModDataComponents.IS_VISIBLE, (Object)true)).booleanValue()) {
            return;
        }
        model.setBackpackStack(stack);
        model.setMultiBufferSource(bufferIn);
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)class_17922;
        boolean translucentType = travelersBackpackItem == ModItems.QUARTZ_TRAVELERS_BACKPACK || travelersBackpackItem == ModItems.SNOW_TRAVELERS_BACKPACK;
        boolean cutoutType = travelersBackpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK;
        class_2960 loc = travelersBackpackItem.getBackpackTexture();
        class_4588 vertexConsumer = bufferIn.getBuffer(translucentType ? class_1921.method_23689((class_2960)loc) : class_1921.method_23572((class_2960)loc));
        if (cutoutType) {
            vertexConsumer = bufferIn.getBuffer(class_1921.method_23576((class_2960)loc));
        }
        poseStack.method_22903();
        BackpackLayer.alignModel(poseStack, humanoidModel, model, entity);
        if (stack.method_57826(class_9334.field_49644) && stack.method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK) {
            loc = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed.png");
            vertexConsumer = bufferIn.getBuffer(class_1921.method_23572((class_2960)loc));
            model.mainBody.method_22699(poseStack, vertexConsumer, packedLightIn, class_4608.field_21444, class_5253.class_5254.method_57174((int)((class_9282)stack.method_57824(class_9334.field_49644)).comp_2384()));
            loc = class_2960.method_60655((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.getBuffer(class_1921.method_23576((class_2960)loc));
        }
        model.method_60879(poseStack, vertexConsumer, packedLightIn, class_4608.field_21444);
        loc = BackpackBlockModel.getSleepingBagTexture((Integer)stack.method_57825(ModDataComponents.SLEEPING_BAG_COLOR, (Object)class_1767.field_7964.method_7789()));
        vertexConsumer = bufferIn.getBuffer(class_1921.method_23576((class_2960)loc));
        model.sleepingBag.method_22698(poseStack, vertexConsumer, packedLightIn, class_4608.field_21444);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            BackpackLayer.renderSupporterStar(player, poseStack, model.mainBody, packedLightIn);
        }
        poseStack.method_22909();
    }

    public static void alignModel(class_4587 poseStack, class_572 parent, BackpackLayerModel backpackModel, class_1309 entity) {
        if (entity.method_18276()) {
            poseStack.method_22904(0.0, -0.155, 0.025);
        }
        parent.method_2818((class_572)backpackModel);
        backpackModel.setupAngles(parent);
        poseStack.method_22904(0.0, 0.175, 0.325);
        poseStack.method_22905(0.85f, 0.85f, 0.85f);
        if (entity.method_6109()) {
            poseStack.method_46416(0.0f, 0.8f, -0.165f);
            float scaleFactor = entity.method_17825();
            poseStack.method_22905(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }

    private static void translateAndRotate(class_4587 poseStack, int x, int y, int z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        poseStack.method_46416((float)x / 16.0f, (float)y / 16.0f, (float)z / 16.0f);
        if (xRot != 0.0f || yRot != 0.0f || zRot != 0.0f) {
            poseStack.method_22907(new Quaternionf().rotationZYX(zRot, yRot, xRot));
        }
        if (xScale != 1.0f || yScale != 1.0f || zScale != 1.0f) {
            poseStack.method_22905(xScale, yScale, zScale);
        }
    }

    private static void renderSupporterStar(class_1657 player, class_4587 poseStack, class_630 parent, int packedLightIn) {
        if (Supporters.SUPPORTERS.contains(player.method_7334().getName())) {
            poseStack.method_22903();
            BackpackLayer.translateAndRotate(poseStack, (int)parent.field_3657, (int)parent.field_3656, (int)parent.field_3655, parent.field_3654, parent.field_3675, parent.field_3674, parent.field_37938, parent.field_37939, parent.field_37940);
            class_1087 starModel = class_310.method_1551().method_1554().method_4742(TravelersBackpackClient.STAR_MODEL);
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            poseStack.method_22905(0.4f, 0.4f, 0.4f);
            poseStack.method_22904(0.15, 0.3, -0.2);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-10.0f));
            BackpackLayer.renderModel(poseStack, starModel, packedLightIn);
            poseStack.method_22909();
            poseStack.method_22909();
        }
    }

    private static void renderModel(class_4587 matrixStack, class_1087 model, int packedLightIn) {
        class_4597.class_4598 src = class_310.method_1551().method_22940().method_23000();
        class_4588 worldrenderer = src.getBuffer(class_1921.method_23576((class_2960)class_1059.field_5275));
        List quads = model.method_4707(null, null, RANDOM);
        for (class_777 quad : quads) {
            worldrenderer.method_22920(matrixStack.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 1.0f, 1.0f, 1.0f, new int[]{packedLightIn, packedLightIn, packedLightIn, packedLightIn}, class_4608.field_21444, true);
        }
        src.method_22993();
    }
}

