/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2970;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    private static final double X = 0.7777777777777778;
    private static final double Y = 0.7692307692307693;
    private static final double Z = 0.7777777777777778;
    private static final double OX = 1.775;
    private static final double OY = 1.655;
    private static final double OZ = 1.778;
    private static final class_265 BACKPACK_TANKS_SHAPE_NORTH = Stream.of(class_2248.method_9541((double)4.108333333333333, (double)0.8857692307692308, (double)6.4446666666666665, (double)11.886111111111111, (double)10.116538461538461, (double)10.333555555555556), class_2248.method_9541((double)4.108333333333333, (double)0.11653846153846148, (double)7.222444444444445, (double)11.886111111111111, (double)0.8857692307692308, (double)10.333555555555556), class_2248.method_9541((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)6.4446666666666665), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334), class_2248.method_9541((double)0.9972222222222221, (double)0.11653846153846148, (double)6.833555555555556, (double)4.108333333333333, (double)7.808846153846154, (double)9.944666666666667), class_2248.method_9541((double)11.886111111111111, (double)0.11653846153846148, (double)6.833555555555556, (double)14.997222222222224, (double)7.808846153846154, (double)9.944666666666667)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_TANKS_SHAPE_SOUTH = Stream.of(class_2248.method_9541((double)4.108333333333333, (double)0.8857692307692308, (double)5.666888888888889, (double)11.886111111111111, (double)10.116538461538461, (double)9.555777777777777), class_2248.method_9541((double)4.108333333333333, (double)0.11653846153846148, (double)5.666888888888889, (double)11.886111111111111, (double)0.8857692307692308, (double)8.778), class_2248.method_9541((double)4.886111111111111, (double)2.4857692307692307, (double)9.555777777777777, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)4.889111111111111, (double)5.663888888888889, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)0.9972222222222221, (double)0.11653846153846148, (double)6.055777777777777, (double)4.108333333333333, (double)7.808846153846154, (double)9.16688888888889), class_2248.method_9541((double)11.886111111111111, (double)0.11653846153846148, (double)6.055777777777777, (double)14.997222222222224, (double)7.808846153846154, (double)9.16688888888889)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_TANKS_SHAPE_WEST = Stream.of(class_2248.method_9541((double)6.441666666666666, (double)0.8857692307692308, (double)4.1113333333333335, (double)10.330555555555556, (double)10.116538461538461, (double)11.889111111111111), class_2248.method_9541((double)7.219444444444445, (double)0.11653846153846148, (double)4.1113333333333335, (double)10.330555555555556, (double)0.8857692307692308, (double)11.889111111111111), class_2248.method_9541((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)6.441666666666666, (double)7.101153846153847, (double)11.111333333333334), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334), class_2248.method_9541((double)6.830555555555556, (double)0.11653846153846148, (double)1.0002222222222223, (double)9.941666666666666, (double)7.808846153846154, (double)4.1113333333333335), class_2248.method_9541((double)6.830555555555556, (double)0.11653846153846148, (double)11.889111111111111, (double)9.941666666666666, (double)7.808846153846154, (double)15.000222222222224)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_TANKS_SHAPE_EAST = Stream.of(class_2248.method_9541((double)5.663888888888889, (double)0.8857692307692308, (double)4.1113333333333335, (double)9.552777777777777, (double)10.116538461538461, (double)11.889111111111111), class_2248.method_9541((double)5.663888888888889, (double)0.11653846153846148, (double)4.1113333333333335, (double)8.775, (double)0.8857692307692308, (double)11.889111111111111), class_2248.method_9541((double)9.552777777777777, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)4.889111111111111, (double)5.663888888888889, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334), class_2248.method_9541((double)6.052777777777777, (double)0.11653846153846148, (double)1.0002222222222223, (double)9.16388888888889, (double)7.808846153846154, (double)4.1113333333333335), class_2248.method_9541((double)6.052777777777777, (double)0.11653846153846148, (double)11.889111111111111, (double)9.16388888888889, (double)7.808846153846154, (double)15.000222222222224)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_SHAPE_NORTH = Stream.of(class_2248.method_9541((double)4.108333333333333, (double)0.8857692307692308, (double)6.4446666666666665, (double)11.886111111111111, (double)10.116538461538461, (double)10.333555555555556), class_2248.method_9541((double)4.108333333333333, (double)0.11653846153846148, (double)7.222444444444445, (double)11.886111111111111, (double)0.8857692307692308, (double)10.333555555555556), class_2248.method_9541((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)6.4446666666666665), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_SHAPE_SOUTH = Stream.of(class_2248.method_9541((double)4.108333333333333, (double)0.8857692307692308, (double)5.666888888888889, (double)11.886111111111111, (double)10.116538461538461, (double)9.555777777777777), class_2248.method_9541((double)4.108333333333333, (double)0.11653846153846148, (double)5.666888888888889, (double)11.886111111111111, (double)0.8857692307692308, (double)8.778), class_2248.method_9541((double)4.886111111111111, (double)2.4857692307692307, (double)9.555777777777777, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)4.889111111111111, (double)5.663888888888889, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_SHAPE_WEST = Stream.of(class_2248.method_9541((double)6.441666666666666, (double)0.8857692307692308, (double)4.1113333333333335, (double)10.330555555555556, (double)10.116538461538461, (double)11.889111111111111), class_2248.method_9541((double)7.219444444444445, (double)0.11653846153846148, (double)4.1113333333333335, (double)10.330555555555556, (double)0.8857692307692308, (double)11.889111111111111), class_2248.method_9541((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)6.441666666666666, (double)7.101153846153847, (double)11.111333333333334), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 BACKPACK_SHAPE_EAST = Stream.of(class_2248.method_9541((double)5.663888888888889, (double)0.8857692307692308, (double)4.1113333333333335, (double)9.552777777777777, (double)10.116538461538461, (double)11.889111111111111), class_2248.method_9541((double)5.663888888888889, (double)0.11653846153846148, (double)4.1113333333333335, (double)8.775, (double)0.8857692307692308, (double)11.889111111111111), class_2248.method_9541((double)9.552777777777777, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)4.889111111111111, (double)5.663888888888889, (double)7.808846153846154, (double)5.666888888888889), class_2248.method_9541((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();

    public TravelersBackpackBlock(class_4970.class_2251 builder) {
        super(builder.method_9629(1.0f, Float.MAX_VALUE).method_51369().method_50012(class_3619.field_15971));
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        boolean hasTanks = false;
        class_2586 class_25862 = getter.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)class_25862;
            hasTanks = backpackBlockEntity.getWrapper().tanksVisible();
        }
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11035 -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_SOUTH;
                }
                yield BACKPACK_SHAPE_SOUTH;
            }
            case class_2350.field_11034 -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_EAST;
                }
                yield BACKPACK_SHAPE_EAST;
            }
            case class_2350.field_11039 -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_WEST;
                }
                yield BACKPACK_SHAPE_WEST;
            }
            default -> hasTanks ? BACKPACK_TANKS_SHAPE_NORTH : BACKPACK_SHAPE_NORTH;
        };
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        ((BackpackBlockEntity)level.method_8321(pos)).openBackpack(player, pos);
        return class_1269.field_21466;
    }

    protected void method_55124(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1927 pExplosion, BiConsumer<class_1799, class_2338> pDropConsumer) {
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity = (BackpackBlockEntity)class_25862;
            if (state.method_26204() == ModBlocks.MELON_TRAVELERS_BACKPACK) {
                BackpackAbilities.melonAbility(blockEntity);
            }
            if (player.method_7337()) {
                class_1799 stack = blockEntity.toItemStack(this.method_8389().method_7854());
                class_1542 itementity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack);
                itementity.method_6988();
                level.method_8649((class_1297)itementity);
            }
            blockEntity.removeSleepingBag(level, (class_2350)state.method_11654((class_2769)FACING));
        }
        return super.method_9576(level, pos, state, player);
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    protected void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockentity = level.method_8321(pos);
            super.method_9536(state, level, pos, newState, isMoving);
            if (blockentity instanceof BackpackBlockEntity) {
                level.method_8455(pos, state.method_26204());
            }
        }
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 blockState, class_1937 level, class_2338 pos) {
        class_2586 class_25862;
        if (level.method_8321(pos) == null || !((class_25862 = level.method_8321(pos)) instanceof BackpackBlockEntity)) {
            return 0;
        }
        BackpackBlockEntity backpack = (BackpackBlockEntity)class_25862;
        float f = 0.0f;
        for (int i = 0; i < backpack.getWrapper().getStorage().getSlots(); ++i) {
            class_1799 itemstack = backpack.getWrapper().getStorage().getStackInSlot(i);
            if (itemstack.method_7960()) continue;
            f += (float)itemstack.method_7947() / (float)Math.min(backpack.getWrapper().getStorage().getSlotLimit(i), backpack.getWrapper().getStorage().getStackInSlot(i).method_7914());
        }
        return class_3532.method_53063((float)(f /= (float)backpack.getWrapper().getStorage().getSlots()), (int)0, (int)15);
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        class_1799 stack = new class_1799((class_1935)this.method_8389(), 1);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity = (BackpackBlockEntity)class_25862;
            blockEntity.toItemStack(stack);
        }
        return stack;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BackpackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 || !TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, state.method_26204().method_8389().method_7854()) ? null : BackpackDeathHelper.getTicker(blockEntityType, ModBlockEntityTypes.BACKPACK, BackpackBlockEntity::tick);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        super.method_9496(state, level, pos, rand);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)class_25862;
            BackpackAbilities.ABILITIES.animateTick(backpackBlockEntity, state, level, pos, rand);
        }
    }

    public int method_9524(class_2680 state, class_1922 getter, class_2338 pos, class_2350 direction) {
        BackpackBlockEntity backpackBlockEntity;
        class_2586 class_25862;
        if (state.method_26204() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK && (class_25862 = getter.method_8321(pos)) instanceof BackpackBlockEntity && (backpackBlockEntity = (BackpackBlockEntity)class_25862).getWrapper().isAbilityEnabled()) {
            return 15;
        }
        return super.method_9524(state, getter, pos, direction);
    }

    public boolean method_9506(class_2680 state) {
        return state.method_26204() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK;
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pMovedByPiston) {
        if (!pOldState.method_27852(pState.method_26204()) && pState.method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.method_9615(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    public void method_9612(class_2680 state, class_1937 pLevel, class_2338 pPos, class_2248 pNeighborBlock, class_2338 pNeighborPos, boolean pMovedByPiston) {
        if (state.method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.method_9612(state, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    public void tryAbsorbWater(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            TanksUpgrade tanksUpgrade;
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)class_25862;
            BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
            if (wrapper.getUpgradeManager().tanksUpgrade.isPresent() && wrapper.isAbilityEnabled() && ((tanksUpgrade = wrapper.getUpgradeManager().tanksUpgrade.get()).getLeftTank().isEmpty() || tanksUpgrade.getLeftTank().getFluid().fluidVariant().getFluid().method_15780((class_3611)class_3612.field_15910) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity() || tanksUpgrade.getRightTank().isEmpty() || tanksUpgrade.getRightTank().getFluid().fluidVariant().getFluid().method_15780((class_3611)class_3612.field_15910) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()) && this.removeWaterBreadthFirstSearch(level, pos, tanksUpgrade)) {
                level.method_20290(2001, pos, class_2248.method_9507((class_2680)class_2246.field_10382.method_9564()));
            }
        }
    }

    private boolean removeWaterBreadthFirstSearch(class_1937 level, class_2338 pos, TanksUpgrade tanksUpgrade) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new class_3545((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            class_3545 tuple = (class_3545)queue.poll();
            class_2338 blockpos = (class_2338)tuple.method_15442();
            int j = (Integer)tuple.method_15441();
            for (class_2350 direction : class_2350.values()) {
                class_2338 blockpos1 = blockpos.method_10093(direction);
                class_2680 blockstate = level.method_8320(blockpos1);
                class_3610 fluidstate = level.method_8316(blockpos1);
                if (!fluidstate.method_15767(class_3486.field_15517)) continue;
                if (blockstate.method_26204() instanceof class_2263 && !((class_2263)blockstate.method_26204()).method_9700(null, (class_1936)level, blockpos1, blockstate).method_7960()) {
                    ++i;
                    if (tanksUpgrade.getLeftTank().isEmpty() || tanksUpgrade.getLeftTank().getFluid().fluidVariant().getFluid().method_15780((class_3611)class_3612.field_15910) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity()) {
                        tanksUpgrade.getLeftTank().fill(new FluidVariantWrapper(FluidVariant.of((class_3611)class_3612.field_15910), 81000L), false);
                    } else if (tanksUpgrade.getRightTank().isEmpty() || tanksUpgrade.getRightTank().getFluid().fluidVariant().getFluid().method_15780((class_3611)class_3612.field_15910) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()) {
                        tanksUpgrade.getRightTank().fill(new FluidVariantWrapper(FluidVariant.of((class_3611)class_3612.field_15910), 81000L), false);
                    }
                    if (j >= 6) continue;
                    queue.add(new class_3545((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.method_26204() instanceof class_2404) {
                    level.method_8652(blockpos1, class_2246.field_10124.method_9564(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new class_3545((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!(blockstate.method_27852(class_2246.field_9993) || blockstate.method_27852(class_2246.field_10463) || blockstate.method_27852(class_2246.field_10376) || blockstate.method_27852(class_2246.field_10238))) {
                    return false;
                }
                class_2586 blockentity = blockstate.method_31709() ? level.method_8321(blockpos1) : null;
                TravelersBackpackBlock.method_9610((class_2680)blockstate, (class_1936)level, (class_2338)blockpos1, (class_2586)blockentity);
                level.method_8652(blockpos1, class_2246.field_10124.method_9564(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new class_3545((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }

    public static void registerDispenserBehaviour() {
        class_7923.field_41178.method_10220().filter(item -> item instanceof TravelersBackpackItem).forEach(item -> class_2315.method_10009((class_1935)item, (class_2357)new class_2970()));
    }
}

