/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blockentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class BackpackBlockEntity
extends class_2586 {
    private BackpackWrapper wrapper = BackpackWrapper.DUMMY;
    private boolean isSleepingBagDeployed = false;
    public ArrayList<Integer> infiniteAccessUsers = new ArrayList();
    public int settingsUser = -1;
    @Nullable
    public class_1657 player;
    public String BACKPACK = "Backpack";
    public String SLEEPING_BAG = "SleepingBag";
    public String SETTINGS_USER = "SettingsUser";
    String TIER = "Tier";
    String INVENTORY = "Inventory";
    String TOOLS_INVENTORY = "ToolsInventory";
    String LEFT_TANK = "LeftTank";
    String RIGHT_TANK = "RightTank";

    public BackpackBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.BACKPACK, pos, state);
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public void removeWrapper() {
        this.wrapper = BackpackWrapper.DUMMY;
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 pRegistries) {
        super.method_11007(compound, pRegistries);
        this.writeBackpack(compound, pRegistries);
        compound.method_10556(this.SLEEPING_BAG, this.isSleepingBagDeployed);
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 pRegistries) {
        super.method_11014(compound, pRegistries);
        this.setBackpackFromNbt(compound, pRegistries);
        if (compound.method_10545(this.TIER)) {
            this.setBackpack(this.getOldDataBackpack(compound, pRegistries), pRegistries);
            compound.method_10551(this.TIER);
        }
        this.isSleepingBagDeployed = compound.method_10577(this.SLEEPING_BAG);
        if (compound.method_10545(this.SETTINGS_USER)) {
            this.settingsUser = compound.method_10550(this.SETTINGS_USER);
        }
    }

    public void setBackpack(class_1799 backpack, class_7225.class_7874 registryAccess) {
        if (backpack.method_7909() instanceof TravelersBackpackItem) {
            if (this.wrapper == BackpackWrapper.DUMMY) {
                this.wrapper = new BackpackWrapper(backpack.method_7972(), 3, registryAccess, null, (class_1936)this.method_10997());
                this.wrapper.setBackpackPos(this.method_11016());
                this.wrapper.saveHandler = () -> {
                    this.method_5431();
                    this.notifyBlockUpdate();
                };
                this.wrapper.abilityHandler = () -> {
                    if (this.method_10997() != null) {
                        this.method_10997().method_8452(this.method_11016(), this.method_11010().method_26204());
                        if (this.method_11010().method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
                            ((TravelersBackpackBlock)this.method_11010().method_26204()).tryAbsorbWater(this.method_10997(), this.method_11016());
                        }
                    }
                };
            } else {
                this.wrapper.setBackpackStack(backpack.method_7972());
            }
        }
    }

    private void setBackpackFromNbt(class_2487 nbt, class_7225.class_7874 pRegistries) {
        this.setBackpack(class_1799.method_57359((class_7225.class_7874)pRegistries, (class_2487)nbt.method_10562(this.BACKPACK)), pRegistries);
    }

    private void writeBackpack(class_2487 ret, class_7225.class_7874 registries) {
        class_1799 backpackCopy = this.wrapper.getBackpackStack().method_7972();
        if (backpackCopy.method_7909() instanceof TravelersBackpackItem) {
            ret.method_10566(this.BACKPACK, backpackCopy.method_57358(registries));
        }
    }

    public class_2350 getBlockDirection() {
        if (this.field_11863 == null || !(this.field_11863.method_8320(this.method_11016()).method_26204() instanceof TravelersBackpackBlock) || !this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)TravelersBackpackBlock.FACING)) {
            return class_2350.field_11043;
        }
        return (class_2350)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)TravelersBackpackBlock.FACING);
    }

    public boolean isSleepingBagDeployed() {
        if (this.getWrapper().hasSleepingBag()) {
            return this.isSleepingBagDeployed;
        }
        return true;
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
        this.method_5431();
        this.notifyBlockUpdate();
    }

    public boolean canPlaceSleepingBag(class_2338 relative) {
        return this.field_11863.method_8320(relative).method_45474() && this.field_11863.method_8621().method_11952(relative);
    }

    public boolean deploySleepingBag(class_1937 level, class_2338 pos) {
        class_2338 sleepingBagPos1;
        class_2338 sleepingBagPos2;
        class_2350 direction = this.getBlockDirection();
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed() && this.canPlaceSleepingBag(sleepingBagPos2 = (sleepingBagPos1 = pos.method_10093(direction)).method_10093(direction))) {
            if (!level.field_9236) {
                class_2680 sleepingBagState = this.getProperSleepingBag();
                level.method_8652(sleepingBagPos1, (class_2680)((class_2680)((class_2680)sleepingBagState.method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12557)).method_11657((class_2769)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.method_8652(sleepingBagPos2, (class_2680)((class_2680)((class_2680)sleepingBagState.method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12560)).method_11657((class_2769)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.method_8452(pos, sleepingBagState.method_26204());
                level.method_8452(sleepingBagPos2, sleepingBagState.method_26204());
            }
            this.setSleepingBagDeployed(true);
            this.getWrapper().saveHandler.run();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(class_1937 level, class_2350 direction) {
        this.isThereSleepingBag(direction);
        if (this.isSleepingBagDeployed()) {
            class_2338 sleepingBagPos1 = this.method_11016().method_10093(direction);
            class_2338 sleepingBagPos2 = sleepingBagPos1.method_10093(direction);
            if (level.method_8320(sleepingBagPos1).method_26204() instanceof SleepingBagBlock && level.method_8320(sleepingBagPos2).method_26204() instanceof SleepingBagBlock) {
                level.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
                level.method_8652(sleepingBagPos2, class_2246.field_10124.method_9564(), 3);
                level.method_8652(sleepingBagPos1, class_2246.field_10124.method_9564(), 3);
                this.setSleepingBagDeployed(false);
                this.getWrapper().saveHandler.run();
                return true;
            }
        } else {
            this.setSleepingBagDeployed(false);
            this.getWrapper().saveHandler.run();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(class_2350 direction) {
        if (this.field_11863.method_8320(this.method_11016().method_10093(direction)).method_26204() instanceof SleepingBagBlock && this.field_11863.method_8320(this.method_11016().method_10093(direction).method_10093(direction)).method_26204() instanceof SleepingBagBlock) {
            return true;
        }
        this.setSleepingBagDeployed(false);
        return false;
    }

    public class_2680 getProperSleepingBag() {
        return switch (this.getWrapper().getSleepingBagColor()) {
            case 0 -> ModBlocks.WHITE_SLEEPING_BAG.method_9564();
            case 1 -> ModBlocks.ORANGE_SLEEPING_BAG.method_9564();
            case 2 -> ModBlocks.MAGENTA_SLEEPING_BAG.method_9564();
            case 3 -> ModBlocks.LIGHT_BLUE_SLEEPING_BAG.method_9564();
            case 4 -> ModBlocks.YELLOW_SLEEPING_BAG.method_9564();
            case 5 -> ModBlocks.LIME_SLEEPING_BAG.method_9564();
            case 6 -> ModBlocks.PINK_SLEEPING_BAG.method_9564();
            case 7 -> ModBlocks.GRAY_SLEEPING_BAG.method_9564();
            case 8 -> ModBlocks.LIGHT_GRAY_SLEEPING_BAG.method_9564();
            case 9 -> ModBlocks.CYAN_SLEEPING_BAG.method_9564();
            case 10 -> ModBlocks.PURPLE_SLEEPING_BAG.method_9564();
            case 11 -> ModBlocks.BLUE_SLEEPING_BAG.method_9564();
            case 12 -> ModBlocks.BROWN_SLEEPING_BAG.method_9564();
            case 13 -> ModBlocks.GREEN_SLEEPING_BAG.method_9564();
            case 14 -> ModBlocks.RED_SLEEPING_BAG.method_9564();
            case 15 -> ModBlocks.BLACK_SLEEPING_BAG.method_9564();
            default -> ModBlocks.RED_SLEEPING_BAG.method_9564();
        };
    }

    protected void method_57567(class_9323.class_9324 pComponents) {
        super.method_57567(pComponents);
        pComponents.method_57839(this.wrapper.getBackpackStack().method_7972().method_57353());
    }

    public class_1799 toItemStack(class_1799 stack) {
        stack.method_57365(this.wrapper.getBackpackStack().method_7972().method_57353());
        return stack;
    }

    private void notifyBlockUpdate() {
        if (this.method_10997() == null) {
            return;
        }
        this.method_10997().method_8413(this.method_11016(), this.method_10997().method_8320(this.method_11016()), this.method_10997().method_8320(this.method_11016()), 3);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper.tickForBlockEntity(backpackBlockEntity);
    }

    public void setSettingsUser(class_1657 player) {
        this.settingsUser = player.method_5628();
        this.notifyBlockUpdate();
    }

    public int getSettingsUser() {
        return this.settingsUser;
    }

    public void removeSettingsUser() {
        this.settingsUser = -1;
        this.notifyBlockUpdate();
    }

    public boolean canOpenSettings(class_1657 player) {
        if (!player.method_37908().field_9236) {
            return this.settingsUser == player.method_5628();
        }
        if (this.settingsUser == -1) {
            return true;
        }
        return this.settingsUser == player.method_5628();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 pRegistries) {
        class_2487 tag = this.method_38244(pRegistries);
        tag.method_10569(this.SETTINGS_USER, this.settingsUser);
        return tag;
    }

    public void openBackpack(class_1657 player, final class_2338 pos) {
        if (!player.method_37908().field_9236) {
            if (this.infiniteAccessUsers.contains(player.method_5628())) {
                this.infiniteAccessUsers.remove((Object)player.method_5628());
            }
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.BlockEntityScreenData>(){
                final /* synthetic */ BackpackBlockEntity this$0;
                {
                    this.this$0 = this$0;
                }

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if (this.this$0.wrapper == BackpackWrapper.DUMMY) {
                        throw new IllegalStateException("BackpackWrapper is not initialized!");
                    }
                    if (this.this$0.canOpenSettings(player)) {
                        return new BackpackSettingsMenu(i, inventory, this.this$0.wrapper);
                    }
                    return new BackpackBlockEntityMenu(i, inventory, this.this$0.infiniteAccessUsers.contains(player.method_5628()) ? player.method_5628() : -1, this.this$0.wrapper);
                }

                public ModScreenHandlerTypes.BlockEntityScreenData getScreenOpeningData(class_3222 player) {
                    return BackpackBlockEntity.saveExtraData(-1, pos);
                }
            });
        }
    }

    public static ModScreenHandlerTypes.SettingsScreenData saveSettingsExtraData(class_2338 pos) {
        return new ModScreenHandlerTypes.SettingsScreenData(true, 3, pos);
    }

    public static ModScreenHandlerTypes.BlockEntityScreenData saveExtraData(int entityId, class_2338 pos) {
        return new ModScreenHandlerTypes.BlockEntityScreenData(entityId, pos);
    }

    public void openSettings(class_1657 player, final class_2338 pos) {
        if (!player.method_37908().field_9236) {
            this.setSettingsUser(player);
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.SettingsScreenData>(){
                final /* synthetic */ BackpackBlockEntity this$0;
                {
                    this.this$0 = this$0;
                }

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if (this.this$0.wrapper == BackpackWrapper.DUMMY) {
                        throw new IllegalStateException("BackpackWrapper is not initialized!");
                    }
                    if (this.this$0.canOpenSettings(player)) {
                        return new BackpackSettingsMenu(i, inventory, this.this$0.wrapper);
                    }
                    return new BackpackBlockEntityMenu(i, inventory, this.this$0.infiniteAccessUsers.contains(player.method_5628()) ? player.method_5628() : -1, this.this$0.wrapper);
                }

                public ModScreenHandlerTypes.SettingsScreenData getScreenOpeningData(class_3222 player) {
                    return BackpackBlockEntity.saveSettingsExtraData(pos);
                }
            });
        }
    }

    public void openBackpackFromCommand(class_1657 player, final class_2338 pos) {
        if (!player.method_37908().field_9236) {
            if (!this.infiniteAccessUsers.contains(player.method_5628())) {
                this.infiniteAccessUsers.add(player.method_5628());
            }
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory<ModScreenHandlerTypes.BlockEntityScreenData>(){
                final /* synthetic */ BackpackBlockEntity this$0;
                {
                    this.this$0 = this$0;
                }

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    if (this.this$0.wrapper == BackpackWrapper.DUMMY) {
                        throw new IllegalStateException("BackpackWrapper is not initialized!");
                    }
                    if (this.this$0.canOpenSettings(player)) {
                        return new BackpackSettingsMenu(i, inventory, this.this$0.wrapper);
                    }
                    return new BackpackBlockEntityMenu(i, inventory, this.this$0.infiniteAccessUsers.contains(player.method_5628()) ? player.method_5628() : -1, this.this$0.wrapper);
                }

                public ModScreenHandlerTypes.BlockEntityScreenData getScreenOpeningData(class_3222 player) {
                    return BackpackBlockEntity.saveExtraData(player.method_5628(), pos);
                }
            });
        }
    }

    public class_1799 getOldDataBackpack(class_2487 compound, class_7225.class_7874 registries) {
        FluidTank tank;
        class_1799 backpack = this.field_11863 != null ? new class_1799((class_1935)this.field_11863.method_8320(this.method_11016()).method_26204().method_8389()) : ModItems.STANDARD_TRAVELERS_BACKPACK.method_7854();
        int tier = Tiers.LEATHER.getOrdinal();
        if (compound.method_10545(this.TIER)) {
            tier = compound.method_10550(this.TIER);
            backpack.method_57379(ModDataComponents.TIER, (Object)tier);
        }
        BackpackWrapper.initializeSize(backpack);
        int storageSlots = (Integer)backpack.method_57824(ModDataComponents.STORAGE_SLOTS);
        int toolSlots = (Integer)backpack.method_57824(ModDataComponents.TOOL_SLOTS);
        int upgradeSlots = (Integer)backpack.method_57824(ModDataComponents.UPGRADE_SLOTS);
        if (compound.method_10545(this.INVENTORY)) {
            ItemStackHandler inventory = new ItemStackHandler(99);
            inventory.deserializeNBT(registries, compound.method_10562(this.INVENTORY));
            backpack.method_57379(ModDataComponents.BACKPACK_CONTAINER, (Object)InventoryHelper.itemsToList(storageSlots, inventory));
        }
        if (compound.method_10545(this.TOOLS_INVENTORY)) {
            ItemStackHandler tools = new ItemStackHandler(12);
            tools.deserializeNBT(registries, compound.method_10562(this.TOOLS_INVENTORY));
            backpack.method_57379(ModDataComponents.TOOLS_CONTAINER, (Object)InventoryHelper.itemsToList(toolSlots, tools));
        }
        FluidVariantWrapper leftFluidStack = FluidVariantWrapper.blank();
        FluidVariantWrapper rightFluidStack = FluidVariantWrapper.blank();
        if (compound.method_10545(this.LEFT_TANK)) {
            tank = new FluidTank(20000L);
            tank.readNbtOld(registries, compound.method_10562(this.LEFT_TANK));
            leftFluidStack = new FluidVariantWrapper((FluidVariant)tank.variant, tank.amount);
        }
        if (compound.method_10545(this.RIGHT_TANK)) {
            tank = new FluidTank(20000L);
            tank.readNbtOld(registries, compound.method_10562(this.RIGHT_TANK));
            rightFluidStack = new FluidVariantWrapper((FluidVariant)tank.variant, tank.amount);
        }
        class_1799 tanksUpgrade = ModItems.TANKS_UPGRADE.method_7854();
        tanksUpgrade.method_57379(ModDataComponents.FLUIDS, (Object)new Fluids(leftFluidStack, rightFluidStack));
        ItemStackHandler upgrades = new ItemStackHandler(6);
        upgrades.setStackInSlot(0, tanksUpgrade);
        backpack.method_57379(ModDataComponents.UPGRADES, (Object)InventoryHelper.itemsToList(upgradeSlots, upgrades));
        return backpack;
    }
}

