/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.ModSupport;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.TechnicalGravestoneBlock;
import net.pneumono.gravestones.content.entity.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.ExperienceKeptCalculation;
import net.pneumono.gravestones.gravestones.GravestoneData;
import net.pneumono.gravestones.gravestones.GravestonePlacement;
import net.pneumono.gravestones.gravestones.GravestonePosition;
import net.pneumono.gravestones.gravestones.GravestoneTime;
import net.pneumono.gravestones.gravestones.PlayerGravestoneData;

public class GravestoneCreation {
    public static void logger(String string) {
        GravestoneCreation.logger(string, LoggerInfoType.INFO, null);
    }

    public static void logger(String string, LoggerInfoType type) {
        GravestoneCreation.logger(string, type, null);
    }

    public static void logger(String string, LoggerInfoType type, Throwable t) {
        if (((Boolean)Gravestones.CONSOLE_INFO.getValue()).booleanValue()) {
            switch (type.ordinal()) {
                case 0: {
                    Gravestones.LOGGER.info(string);
                    break;
                }
                case 1: {
                    Gravestones.LOGGER.warn(string);
                    break;
                }
                case 2: {
                    if (t != null) {
                        Gravestones.LOGGER.error(string, t);
                        break;
                    }
                    Gravestones.LOGGER.error(string);
                }
            }
        }
    }

    public static String posToString(class_2338 pos) {
        return "(" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ")";
    }

    public static void handleGravestones(class_1657 player) {
        GravestoneCreation.logger("----- ----- Beginning Gravestone Work ----- -----");
        GravestoneCreation.logger("This mostly exists for debugging purposes, but might be useful for server owners. If you don't want to see all this every time someone dies, disable 'console_info' in the config!");
        class_1937 world = player.method_37908();
        class_2338 playerPos = player.method_24515();
        String playerName = player.method_5477().getString();
        GameProfile playerProfile = player.method_7334();
        if (world.method_8450().method_8355(class_1928.field_19389)) {
            GravestoneCreation.logger("Nevermind, keepInventory is on!");
            GravestoneCreation.logger("----- ----- Ending Gravestone Work ----- -----");
            return;
        }
        class_2338 gravestonePos = GravestonePlacement.placeGravestone(world, playerPos);
        if (gravestonePos == null) {
            GravestoneCreation.logger("Gravestone was not placed successfully! The items have been dropped on the floor", LoggerInfoType.ERROR);
        } else {
            Object object;
            Object uuid = "";
            if (((Boolean)Gravestones.CONSOLE_INFO.getValue()).booleanValue()) {
                uuid = " (" + String.valueOf(playerProfile.getId()) + ")";
            }
            Gravestones.LOGGER.info("Placed {}'s{} Gravestone at {}", new Object[]{playerName, uuid, GravestoneCreation.posToString(gravestonePos)});
            MinecraftServer server = world.method_8503();
            if (server != null && ((Boolean)Gravestones.BROADCAST_COORDINATES_IN_CHAT.getValue()).booleanValue()) {
                server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"gravestones.grave_spawned", (Object[])new Object[]{playerName, GravestoneCreation.posToString(gravestonePos)}).method_27692(class_124.field_1075), false);
            }
            if ((object = world.method_8321(gravestonePos)) instanceof TechnicalGravestoneBlockEntity) {
                TechnicalGravestoneBlockEntity gravestone = (TechnicalGravestoneBlockEntity)object;
                gravestone.setGraveOwner(new class_9296(playerProfile));
                gravestone.setSpawnDate(GravestoneTime.getCurrentTimeAsString(), world.method_8510());
                GravestoneCreation.insertPlayerItemsAndExperience(gravestone, player);
                GravestoneCreation.insertModData(player, gravestone);
                world.method_8413(gravestonePos, world.method_8320(gravestonePos), world.method_8320(gravestonePos), 2);
                GravestoneCreation.logger("Gave Gravestone it's data (graveOwner, spawnDate, and inventory)");
            } else {
                GravestoneCreation.logger("Gravestone position does not have a block entity!", LoggerInfoType.ERROR);
            }
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            List<GravestonePosition> oldGravePositions = GravestoneCreation.readAndWriteData(serverWorld, playerProfile, playerName, gravestonePos);
            if (!((Boolean)Gravestones.DECAY_WITH_DEATHS.getValue()).booleanValue()) {
                GravestoneCreation.logger("Gravestone death damage has been disabled in the config, so no graves were damaged");
            } else if (oldGravePositions == null) {
                GravestoneCreation.logger("No graves to damage!");
            } else {
                ArrayList<GravestonePosition> usedPositions = new ArrayList<GravestonePosition>();
                usedPositions.add(new GravestonePosition(serverWorld.method_27983().method_29177(), gravestonePos));
                for (GravestonePosition oldPos : oldGravePositions) {
                    if (usedPositions.contains(oldPos)) {
                        GravestoneCreation.logger("Gravestone at " + GravestoneCreation.posToString(oldPos.asBlockPos()) + " in dimension " + oldPos.dimension.toString() + " has already been damaged, skipping");
                        continue;
                    }
                    class_3218 graveWorld = serverWorld.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)oldPos.dimension));
                    if (graveWorld == null) {
                        GravestoneCreation.logger("GravePosition's dimension (" + oldPos.dimension.toString() + ") does not exist!", LoggerInfoType.ERROR);
                    } else if (!graveWorld.method_8320(oldPos.asBlockPos()).method_27852(GravestonesRegistry.GRAVESTONE_TECHNICAL)) {
                        GravestoneCreation.logger("No gravestone was found at the position " + GravestoneCreation.posToString(oldPos.asBlockPos()) + " in dimension " + oldPos.dimension.toString() + ". Most likely this is because the grave has already been collected, or was decayed");
                    } else {
                        String damageType;
                        int deathDamage = (Integer)graveWorld.method_8320(oldPos.asBlockPos()).method_11654((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE);
                        int ageDamage = (Integer)graveWorld.method_8320(oldPos.asBlockPos()).method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE);
                        String graveData = "Age: " + ageDamage + ", Death: " + deathDamage;
                        if (ageDamage + deathDamage >= 2) {
                            damageType = "broken";
                            graveWorld.method_22352(oldPos.asBlockPos(), true);
                        } else {
                            damageType = "damaged";
                            graveWorld.method_8501(oldPos.asBlockPos(), (class_2680)graveWorld.method_8320(oldPos.asBlockPos()).method_11657((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE, (Comparable)Integer.valueOf(deathDamage + 1)));
                        }
                        GravestoneCreation.logger("Gravestone (" + graveData + ") " + damageType + " at the position " + GravestoneCreation.posToString(oldPos.asBlockPos()) + " in dimension " + oldPos.dimension.toString());
                    }
                    usedPositions.add(oldPos);
                }
            }
        }
        GravestoneCreation.logger("----- ----- Ending Gravestone Work ----- -----");
    }

    public static void insertPlayerItemsAndExperience(TechnicalGravestoneBlockEntity gravestone, class_1657 player) {
        GravestoneCreation.logger("Inserting Inventory items and experience into grave...");
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!class_1890.method_60142((class_1799)inventory.method_5438(i), (class_9331)class_9701.field_51655)) {
                gravestone.method_5447(i, inventory.method_5441(i));
                continue;
            }
            inventory.method_5441(i);
        }
        GravestoneCreation.logger("Items inserted!");
        if (((Boolean)Gravestones.STORE_EXPERIENCE.getValue()).booleanValue()) {
            int experience = ((ExperienceKeptCalculation)((Object)Gravestones.EXPERIENCE_KEPT.getValue())).calculateExperienceKept(player);
            if (((Boolean)Gravestones.EXPERIENCE_CAP.getValue()).booleanValue() && experience > 100) {
                experience = 100;
            }
            gravestone.setExperience(experience);
            player.field_7510 = 0.0f;
            player.field_7520 = 0;
            player.field_7495 = 0;
            GravestoneCreation.logger("Experience inserted!");
        } else {
            GravestoneCreation.logger("Experience storing is disabled!");
        }
    }

    public static void insertModData(class_1657 entity, TechnicalGravestoneBlockEntity gravestone) {
        GravestoneCreation.logger("Inserting additional mod data into grave...");
        for (ModSupport support : GravestonesApi.getModSupports()) {
            support.insertData(entity, gravestone);
        }
        GravestoneCreation.logger("Data inserted!");
    }

    private static List<GravestonePosition> readAndWriteData(class_3218 serverWorld, GameProfile playerProfile, String playerName, class_2338 gravestonePos) {
        UUID uuid = playerProfile.getId();
        File gravestoneFile = new File(serverWorld.method_8503().method_27050(class_5218.field_24188).toString(), "gravestone_data.json");
        List<GravestonePosition> posList = null;
        if (!gravestoneFile.exists()) {
            GravestoneCreation.logger("No gravestone data file exists! Creating one", LoggerInfoType.WARN);
            try {
                BufferedWriter writer = Files.newBufferedWriter(gravestoneFile.toPath(), new OpenOption[0]);
                new GsonBuilder().serializeNulls().setPrettyPrinting().create().toJson((Object)new GravestoneData(), (Appendable)writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                GravestoneCreation.logger("Could not create gravestone data file.", LoggerInfoType.ERROR, e);
            }
        }
        try {
            class_2960 dimension = serverWorld.method_27983().method_29177();
            GravestoneCreation.logger("Reading gravestone data file");
            BufferedReader reader = Files.newBufferedReader(gravestoneFile.toPath());
            GravestoneData data = (GravestoneData)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, GravestoneData.class);
            ((Reader)reader).close();
            if (!data.hasData()) {
                GravestoneCreation.logger("Gravestone data file has no data!");
            }
            GravestoneCreation.logger("Updating data/creating new data");
            posList = data.getPlayerGravePositions(uuid);
            PlayerGravestoneData playerData = data.getPlayerData(uuid);
            if (playerData != null) {
                playerData.shiftGraves(new GravestonePosition(dimension, gravestonePos));
            } else {
                playerData = new PlayerGravestoneData(uuid, new GravestonePosition(dimension, gravestonePos));
                GravestoneCreation.logger("Player does not have existing gravestone data, and so new data was created");
            }
            data.setPlayerData(playerData, uuid, new GravestonePosition(dimension, gravestonePos));
            GravestoneCreation.logger("Data added, " + playerName + " (" + String.valueOf(uuid) + ") has a new gravestone at " + GravestoneCreation.posToString(playerData.firstGrave.asBlockPos()) + " in dimension " + playerData.firstGrave.dimension.toString());
            GravestoneCreation.logger("Writing updated data back to file");
            BufferedWriter writer = Files.newBufferedWriter(gravestoneFile.toPath(), new OpenOption[0]);
            new GsonBuilder().serializeNulls().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
            GravestoneCreation.logger("Attempting to damage previous graves");
        }
        catch (IOException e) {
            GravestoneCreation.logger("Could not update gravestone data file!", LoggerInfoType.ERROR, e);
        }
        return posList;
    }

    public static enum LoggerInfoType {
        INFO,
        WARN,
        ERROR;

    }
}

