/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content.entity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1262;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9296;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.content.GravestoneSkeletonEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.TechnicalGravestoneBlock;
import net.pneumono.gravestones.content.entity.AbstractGravestoneBlockEntity;
import net.pneumono.gravestones.content.entity.ImplementedInventory;
import net.pneumono.gravestones.gravestones.DecayTimeType;
import net.pneumono.gravestones.gravestones.GravestoneTime;

public class TechnicalGravestoneBlockEntity
extends AbstractGravestoneBlockEntity
implements ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)127, (Object)class_1799.field_8037);
    private int experience;
    private class_2499 modData = new class_2499();
    private class_9296 graveOwner;
    private String spawnDateTime;
    private long spawnDateTicks;

    public TechnicalGravestoneBlockEntity(class_2338 pos, class_2680 state) {
        super(GravestonesRegistry.TECHNICAL_GRAVESTONE_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("experience", this.experience);
        if (this.graveOwner != null) {
            nbt.method_10566("owner", (class_2520)class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.graveOwner).getOrThrow());
        }
        if (this.spawnDateTime != null) {
            nbt.method_10582("spawnDateTime", this.spawnDateTime);
        }
        if (this.spawnDateTicks != 0L) {
            nbt.method_10544("spawnDateTicks", this.spawnDateTicks);
        }
        if (this.modData != null) {
            nbt.method_10566("modData", (class_2520)this.modData);
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        if (nbt.method_10573("experience", 3)) {
            this.experience = nbt.method_10550("experience");
        }
        if (nbt.method_10545("owner")) {
            class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("owner")).resultOrPartial(string -> Gravestones.LOGGER.error("Failed to load profile from gravestone: {}", string)).ifPresent(this::setGraveOwner);
        }
        if (nbt.method_10573("spawnDateTime", 8)) {
            this.spawnDateTime = nbt.method_10558("spawnDateTime");
        }
        if (nbt.method_10573("spawnDateTicks", 4)) {
            this.spawnDateTicks = nbt.method_10537("spawnDateTicks");
        }
        if (nbt.method_10573("modData", 9)) {
            this.modData = nbt.method_10554("modData", 10);
        }
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, TechnicalGravestoneBlockEntity entity) {
        TechnicalGravestoneBlockEntity gravestone;
        class_9296 profileComponent;
        if (world.method_8510() % 20L == 0L) {
            if (!world.method_8608()) {
                if (((Boolean)Gravestones.DECAY_WITH_TIME.getValue()).booleanValue() && entity.getGraveOwner() != null) {
                    long timeUnit;
                    long difference = Gravestones.GRAVESTONE_DECAY_TIME_TYPE.getValue() == DecayTimeType.TICKS ? world.method_8510() - entity.spawnDateTicks : (entity.spawnDateTime != null ? GravestoneTime.getDifferenceInSeconds(GravestoneTime.getCurrentTimeAsString(), entity.spawnDateTime) * 20L : 0L);
                    if (difference > (timeUnit = ((Long)Gravestones.DECAY_TIME.getValue()).longValue()) * 3L) {
                        world.method_22352(blockPos, true);
                    } else if (difference > timeUnit * 2L && (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE) <= 1) {
                        world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE, (Comparable)Integer.valueOf(2)));
                    } else if (difference > timeUnit && (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE) <= 0) {
                        world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE, (Comparable)Integer.valueOf(1)));
                    }
                    TechnicalGravestoneBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)state);
                }
                if ((Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DAMAGE) != (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE) + (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE)) {
                    if ((Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE) + (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE) > 2) {
                        world.method_22352(blockPos, true);
                    } else {
                        world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)TechnicalGravestoneBlock.DAMAGE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.AGE_DAMAGE) + (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DEATH_DAMAGE))));
                    }
                    TechnicalGravestoneBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)state);
                }
                if ((Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DAMAGE) >= 3) {
                    world.method_22352(blockPos, true);
                    TechnicalGravestoneBlockEntity.method_31663((class_1937)world, (class_2338)blockPos, (class_2680)state);
                }
            }
            if (((Boolean)Gravestones.SPAWN_GRAVESTONE_SKELETONS.getValue()).booleanValue()) {
                int entityCount;
                boolean ownerNearby = false;
                class_9296 profileComponent2 = entity.getGraveOwner();
                if (profileComponent2 != null) {
                    class_238 box = class_238.method_54784((class_2338)blockPos.method_10087(30).method_10077(50).method_10088(50), (class_2338)blockPos.method_10086(30).method_10076(50).method_10089(50));
                    for (class_1297 nearbyEntity : world.method_8335(null, box)) {
                        class_1657 player;
                        if (!(nearbyEntity instanceof class_1657) || (player = (class_1657)nearbyEntity).method_7334().getId() != profileComponent2.comp_2413().getId()) continue;
                        ownerNearby = true;
                    }
                }
                if (ownerNearby && (entityCount = entity.countEntities(world)) < 5 && world.method_8510() % 900L == 0L) {
                    GravestoneSkeletonEntity spawned = new GravestoneSkeletonEntity(world);
                    ArrayList<class_2338> possiblePos = new ArrayList<class_2338>();
                    for (int x = -5; x < 6; ++x) {
                        for (int y = -5; y < 6; ++y) {
                            for (int z = -5; z < 6; ++z) {
                                possiblePos.add(new class_2338(entity.method_11016().method_10263() + x, entity.method_11016().method_10264() + y, entity.method_11016().method_10260() + z));
                            }
                        }
                    }
                    Random random = new Random();
                    class_2338 finalPos = null;
                    while (!possiblePos.isEmpty()) {
                        int randInt = random.nextInt(possiblePos.size());
                        class_2338 possible = (class_2338)possiblePos.get(randInt);
                        possiblePos.remove(randInt);
                        boolean tooFar = false;
                        while (world.method_8320(possible.method_10074()).method_26215() && !tooFar) {
                            if (possible.method_10074().method_10264() < blockPos.method_10087(5).method_10264()) {
                                tooFar = true;
                            }
                            possible = possible.method_10074();
                        }
                        if (tooFar || !world.method_8320(possible).method_26215() || !world.method_8320(possible.method_10084()).method_26215()) continue;
                        finalPos = possible;
                        break;
                    }
                    if (finalPos == null) {
                        finalPos = blockPos;
                    }
                    spawned.method_23327((double)finalPos.method_10263() + 0.5, (double)finalPos.method_10264() + 0.1, (double)finalPos.method_10260() + 0.5);
                    spawned.method_6092(new class_1293(class_1294.field_5918, -1));
                    if ((double)random.nextFloat() > 0.5) {
                        spawned.method_5673(class_1304.field_6173, class_1802.field_8102.method_7854());
                        spawned.method_5673(class_1304.field_6169, class_1802.field_8267.method_7854());
                    } else {
                        spawned.method_5673(class_1304.field_6169, class_1802.field_8743.method_7854());
                    }
                    spawned.method_5946(class_1304.field_6173, 0.0f);
                    spawned.method_5946(class_1304.field_6169, 0.0f);
                    world.method_8649((class_1297)spawned);
                }
            }
        }
        boolean ownerNearby = false;
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof TechnicalGravestoneBlockEntity && (profileComponent = (gravestone = (TechnicalGravestoneBlockEntity)blockEntity).getGraveOwner()) != null) {
            class_238 box = class_238.method_54784((class_2338)blockPos.method_10087(5).method_10077(5).method_10088(5), (class_2338)blockPos.method_10086(5).method_10076(5).method_10089(5));
            List entities = world.method_8335(null, box);
            for (class_1297 tempEntity : entities) {
                class_1657 player;
                if (!(tempEntity instanceof class_1657) || (player = (class_1657)tempEntity).method_7334().getId() != gravestone.getGraveOwner().comp_2413().getId()) continue;
                ownerNearby = true;
            }
        }
        if (ownerNearby && !world.method_8608() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            Random random = new Random();
            serverWorld.method_14199((class_2394)class_2398.field_11220, (double)blockPos.method_10263() + (double)random.nextFloat() * 0.6 + 0.2, (double)((float)blockPos.method_10264() + random.nextFloat() / 10.0f) + 0.25, (double)blockPos.method_10260() + (double)random.nextFloat() * 0.6 + 0.2, 1, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, 0.1);
        }
    }

    private int countEntities(class_1937 world) {
        class_238 box = class_238.method_54784((class_2338)this.method_11016().method_10087(15).method_10077(15).method_10088(15), (class_2338)this.method_11016().method_10086(15).method_10076(15).method_10089(15));
        List entities = world.method_8335(null, box);
        int entityCount = 0;
        for (class_1297 nearbyEntity : entities) {
            if (!(nearbyEntity instanceof GravestoneSkeletonEntity)) continue;
            ++entityCount;
        }
        return entityCount;
    }

    public void setGraveOwner(class_9296 graveOwner) {
        this.graveOwner = graveOwner;
        this.method_5431();
    }

    public class_9296 getGraveOwner() {
        return this.graveOwner;
    }

    public void setSpawnDate(String spawnDateTime, long spawnDateTicks) {
        this.spawnDateTime = spawnDateTime;
        this.spawnDateTicks = spawnDateTicks;
        this.method_5431();
    }

    public String getSpawnDateTime() {
        return this.spawnDateTime;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getExperienceToDrop(class_2680 state) {
        int experience = this.getExperience();
        if (((Boolean)Gravestones.EXPERIENCE_DECAY.getValue()).booleanValue()) {
            return experience / ((Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DAMAGE) + 1);
        }
        return experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public void addOrReplaceModData(String modID, class_2487 data) {
        class_2499 newData = new class_2499();
        for (class_2520 element : this.modData) {
            class_2487 compound;
            if (element instanceof class_2487 && (compound = (class_2487)element).method_10545("modID") && Objects.equals(compound.method_10558("modID"), modID)) continue;
            newData.add((Object)element);
        }
        class_2487 compound = new class_2487();
        compound.method_10582("modID", modID);
        compound.method_10566("data", (class_2520)data);
        newData.add((Object)compound);
        this.modData = newData;
    }

    public class_2487 getModData(String modID) {
        for (int i = 0; i < this.modData.size(); ++i) {
            class_2487 nbt = this.modData.method_10602(i);
            if (nbt == null || !nbt.method_10545("modID") || !Objects.equals(nbt.method_10558("modID"), modID)) continue;
            return nbt.method_10562("data");
        }
        return null;
    }

    public class_2499 getAllModData() {
        return this.modData;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public class_2350 getGravestoneDirection() {
        return class_2350.field_11043;
    }
}

