/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8242;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.entity.AbstractGravestoneBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AestheticGravestoneBlockEntity
extends AbstractGravestoneBlockEntity {
    private class_8242 text = this.createText();
    private boolean waxed;

    public AestheticGravestoneBlockEntity(class_2338 pos, class_2680 state) {
        super(GravestonesRegistry.AESTHETIC_GRAVESTONE_ENTITY, pos, state);
    }

    protected class_8242 createText() {
        return new class_8242();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_6903 dynamicOps = registryLookup.method_57093((DynamicOps)class_2509.field_11560);
        class_8242.field_43298.encodeStart((DynamicOps)dynamicOps, (Object)this.text).resultOrPartial(arg_0 -> ((Logger)Gravestones.LOGGER).error(arg_0)).ifPresent(frontText -> nbt.method_10566("text", frontText));
        nbt.method_10556("is_waxed", this.waxed);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_6903 dynamicOps = registryLookup.method_57093((DynamicOps)class_2509.field_11560);
        if (nbt.method_10545("text")) {
            class_8242.field_43298.parse((DynamicOps)dynamicOps, (Object)nbt.method_10562("text")).resultOrPartial(arg_0 -> ((Logger)Gravestones.LOGGER).error(arg_0)).ifPresent(signText -> {
                this.text = this.parseLines((class_8242)signText);
            });
        }
        this.waxed = nbt.method_10577("is_waxed");
    }

    private class_8242 parseLines(class_8242 signText) {
        for (int i = 0; i < 4; ++i) {
            class_2561 text = this.parseLine(signText.method_49859(i, false));
            class_2561 text2 = this.parseLine(signText.method_49859(i, true));
            signText = signText.method_49858(i, text, text2);
        }
        return signText;
    }

    private class_2561 parseLine(class_2561 text) {
        class_1937 world = this.field_11863;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            try {
                return class_2564.method_10881((class_2168)AestheticGravestoneBlockEntity.createCommandSource(null, (class_1937)serverWorld, this.field_11867), (class_2561)text, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public boolean canRunCommandClickEvent(class_1657 player) {
        return this.isWaxed() && this.getText().method_49874(player);
    }

    public boolean runCommandClickEvent(class_1657 player, class_1937 world, class_2338 pos) {
        boolean bl = false;
        for (class_2561 text : this.getText().method_49877(player.method_33793())) {
            class_2583 style = text.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            Objects.requireNonNull(player.method_5682()).method_3734().method_44252(AestheticGravestoneBlockEntity.createCommandSource(player, world, pos), clickEvent.method_10844());
            bl = true;
        }
        return bl;
    }

    private static class_2168 createCommandSource(@Nullable class_1657 player, class_1937 world, class_2338 pos) {
        String string = player == null ? "Sign" : player.method_5477().getString();
        class_5250 text = player == null ? class_2561.method_43470((String)"Sign") : player.method_5476();
        return new class_2168(class_2165.field_17395, class_243.method_24953((class_2382)pos), class_241.field_1340, (class_3218)world, 2, string, (class_2561)text, world.method_8503(), (class_1297)player);
    }

    @Override
    public class_2350 getGravestoneDirection() {
        class_2680 state;
        class_1937 world = this.method_10997();
        if (world != null && (state = world.method_8320(this.method_11016())).method_28501().contains(class_2741.field_12481)) {
            return (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        }
        return class_2350.field_11043;
    }

    public class_8242 getText() {
        return this.text;
    }

    public boolean isWaxed() {
        return this.waxed;
    }
}

