/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import com.mojang.serialization.MapCodec;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9296;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.ModSupport;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.entity.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneCreation;
import org.jetbrains.annotations.Nullable;

public class TechnicalGravestoneBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<TechnicalGravestoneBlock> CODEC = TechnicalGravestoneBlock.method_54094(TechnicalGravestoneBlock::new);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 DAMAGE = class_2758.method_11867((String)"damage", (int)0, (int)2);
    public static final class_2758 AGE_DAMAGE = class_2758.method_11867((String)"age_damage", (int)0, (int)2);
    public static final class_2758 DEATH_DAMAGE = class_2758.method_11867((String)"death_damage", (int)0, (int)2);
    private static final class_265 SHAPE = Stream.of(class_2248.method_9541((double)4.0, (double)14.0, (double)13.0, (double)12.0, (double)16.0, (double)15.0), class_2248.method_9541((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)15.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)3.0, (double)14.0)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();

    public TechnicalGravestoneBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DAMAGE});
        builder.method_11667(new class_2769[]{AGE_DAMAGE});
        builder.method_11667(new class_2769[]{DEATH_DAMAGE});
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        this.createSoulParticles(world, pos);
        return super.method_9576(world, pos, state, player);
    }

    public void method_9565(class_2680 state, class_3218 world, class_2338 pos, class_1799 tool, boolean dropExperience) {
        super.method_9565(state, world, pos, tool, dropExperience);
        class_2586 entity = world.method_8321(pos);
        if (entity instanceof TechnicalGravestoneBlockEntity) {
            TechnicalGravestoneBlockEntity gravestone = (TechnicalGravestoneBlockEntity)entity;
            class_1303.method_31493((class_3218)world, (class_243)new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), (int)gravestone.getExperienceToDrop(state));
            for (ModSupport support : GravestonesApi.getModSupports()) {
                support.onBreak(gravestone);
            }
        }
    }

    private void createSoulParticles(class_1937 world, class_2338 pos) {
        Random random = new Random();
        if (!world.method_8608() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (int i = 0; i < 16; ++i) {
                serverWorld.method_14199((class_2394)class_2398.field_23114, (double)pos.method_10263() + (double)random.nextFloat() * 0.6 + 0.2, (double)((float)pos.method_10264() + random.nextFloat() / 10.0f) + 0.25, (double)pos.method_10260() + (double)random.nextFloat() * 0.6 + 0.2, 1, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, 0.1);
            }
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof TechnicalGravestoneBlockEntity) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((TechnicalGravestoneBlockEntity)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    protected void method_55124(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        if (!world.method_8608() && !(player instanceof FakePlayer) && (class_25862 = world.method_8321(pos)) instanceof TechnicalGravestoneBlockEntity) {
            TechnicalGravestoneBlockEntity gravestone = (TechnicalGravestoneBlockEntity)class_25862;
            class_9296 graveOwner = gravestone.getGraveOwner();
            if (graveOwner != null && graveOwner.comp_2413().getId().equals(player.method_7334().getId()) || !((Boolean)Gravestones.GRAVESTONE_ACCESSIBLE_OWNER_ONLY.getValue()).booleanValue()) {
                Object uuid = "";
                if (((Boolean)Gravestones.CONSOLE_INFO.getValue()).booleanValue()) {
                    uuid = " (" + String.valueOf(player.method_7334().getId()) + ")";
                }
                Gravestones.LOGGER.info("{}{} has found their grave at {}", new Object[]{player.method_5477().getString(), uuid, GravestoneCreation.posToString(pos)});
                GravestoneCreation.logger("Returning items...");
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < gravestone.method_5439(); ++i) {
                    if (gravestone.method_5438(i) == null) continue;
                    if (i < 41 && inventory.method_5438(i).method_7960()) {
                        inventory.method_5447(i, gravestone.method_5438(i));
                    } else {
                        class_1542 item = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), gravestone.method_5438(i));
                        world.method_8649((class_1297)item);
                    }
                    gravestone.method_5441(i);
                }
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    class_1303.method_31493((class_3218)serverWorld, (class_243)new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), (int)gravestone.getExperienceToDrop(state));
                    gravestone.setExperience(0);
                }
                for (ModSupport support : GravestonesApi.getModSupports()) {
                    support.onCollect(player, gravestone);
                }
                player.method_7281(GravestonesRegistry.GRAVESTONES_COLLECTED);
                MinecraftServer server = world.method_8503();
                if (server != null && ((Boolean)Gravestones.BROADCAST_COLLECT_IN_CHAT.getValue()).booleanValue()) {
                    if (((Boolean)Gravestones.BROADCAST_COORDINATES_IN_CHAT.getValue()).booleanValue()) {
                        server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"gravestones.player_collected_grave_at_coords", (Object[])new Object[]{player.method_5477().getString(), GravestoneCreation.posToString(pos)}).method_27692(class_124.field_1075), false);
                    } else {
                        server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"gravestones.player_collected_grave", (Object[])new Object[]{player.method_5477().getString()}).method_27692(class_124.field_1075), false);
                    }
                }
                world.method_22352(pos, true);
            } else if (graveOwner != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"gravestones.cannot_open_wrong_player", (Object[])new Object[]{graveOwner.comp_2410().orElse("???")}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"gravestones.cannot_open_no_owner"), true);
            }
            this.createSoulParticles(world, pos);
        }
        return class_1269.field_5812;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TechnicalGravestoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return TechnicalGravestoneBlock.method_31618(type, GravestonesRegistry.TECHNICAL_GRAVESTONE_ENTITY, TechnicalGravestoneBlockEntity::tick);
    }
}

