/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.structs;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;

public class DynamicPriorityQueue<E> {
    private final ObjectLinkedOpenHashSet<E>[] priorities;
    private final Object2IntMap<E> priorityMap = new Object2IntOpenHashMap();
    private int currentMinPriority = 0;

    public DynamicPriorityQueue(int priorityCount) {
        this.priorities = new ObjectLinkedOpenHashSet[priorityCount];
        for (int i = 0; i < priorityCount; ++i) {
            this.priorities[i] = new ObjectLinkedOpenHashSet();
        }
    }

    public synchronized void enqueue(E element, int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            throw new IllegalArgumentException("Priority out of range");
        }
        if (this.priorityMap.containsKey(element)) {
            throw new IllegalArgumentException("Element already in queue");
        }
        if (!this.priorities[priority].add(element)) {
            throw new AssertionError((Object)("Element already in priority " + priority));
        }
        this.priorityMap.put(element, priority);
        if (priority < this.currentMinPriority) {
            this.currentMinPriority = priority;
        }
    }

    public synchronized boolean changePriority(E element, int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            throw new IllegalArgumentException("Priority out of range");
        }
        if (!this.priorityMap.containsKey(element)) {
            return false;
        }
        int oldPriority = this.priorityMap.getInt(element);
        if (oldPriority == priority) {
            return false;
        }
        if (!this.priorities[oldPriority].remove(element)) {
            throw new AssertionError((Object)("Element not found in priority " + oldPriority));
        }
        if (!this.priorities[priority].addAndMoveToLast(element)) {
            throw new AssertionError((Object)("Element already in priority " + priority));
        }
        this.priorityMap.put(element, priority);
        if (priority < this.currentMinPriority) {
            this.currentMinPriority = priority;
        }
        return true;
    }

    public synchronized E dequeue() {
        while (this.currentMinPriority < this.priorities.length) {
            ObjectLinkedOpenHashSet<E> priority = this.priorities[this.currentMinPriority];
            if (priority.isEmpty()) {
                ++this.currentMinPriority;
                continue;
            }
            Object element = priority.removeFirst();
            this.priorityMap.removeInt(element);
            return (E)element;
        }
        return null;
    }

    public synchronized boolean contains(E element) {
        return this.priorityMap.containsKey(element);
    }

    public synchronized void remove(E element) {
        if (!this.priorityMap.containsKey(element)) {
            return;
        }
        int priority = this.priorityMap.removeInt(element);
        if (!this.priorities[priority].remove(element)) {
            throw new AssertionError((Object)("Element not found in priority " + priority));
        }
    }

    public int size() {
        return this.priorityMap.size();
    }
}

