/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_6686;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import net.minecraft.class_7891;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndBiome
extends WoverBiomeData
implements SurfaceMaterialProvider {
    public static final MapCodec<EndBiome> CODEC = EndBiome.codec((RecordCodecBuilder)Codec.BOOL.fieldOf("has_caves").orElse((Object)true).forGetter(o -> o.hasCaves), (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)Config.DEFAULT_MATERIAL).forGetter(o -> o.surfMatProv), EndBiome::new);
    public static final class_7243<EndBiome> KEY_CODEC = class_7243.method_42116(CODEC);
    private boolean hasCaves = true;
    protected SurfaceMaterialProvider surfMatProv = Config.DEFAULT_MATERIAL;

    public EndBiome(float fogDensity, @NotNull class_5321<class_1959> biome, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable class_5321<class_1959> edge, @Nullable class_5321<class_1959> parent, boolean hasCaves, SurfaceMaterialProvider surface) {
        super(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent);
        this.hasCaves = hasCaves;
        this.surfMatProv = surface;
    }

    public void datagenSetup(class_7891<BiomeData> dataContext) {
    }

    public class_7243<? extends WoverBiomeData> codec() {
        return KEY_CODEC;
    }

    void setHasCaves(boolean v) {
        this.hasCaves = v;
    }

    public boolean hasCaves() {
        return this.hasCaves;
    }

    public class_2680 getTopMaterial() {
        return this.surfMatProv.getTopMaterial();
    }

    public class_2680 getUnderMaterial() {
        return this.surfMatProv.getUnderMaterial();
    }

    public class_2680 getAltTopMaterial() {
        return this.surfMatProv.getAltTopMaterial();
    }

    public boolean generateFloorRule() {
        return this.surfMatProv.generateFloorRule();
    }

    public SurfaceRuleBuilder surface() {
        return this.surfMatProv.surface();
    }

    public static class_2680 findTopMaterial(class_6880<class_1959> biome) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider(biome).map(SurfaceMaterialProvider::getTopMaterial).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static class_2680 findTopMaterial(class_5281 world, class_2338 pos) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider((class_6880)WoverBiomePicker.getBiomeAt((class_5281)world, (class_2338)pos)).map(SurfaceMaterialProvider::getTopMaterial).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static class_2680 findUnderMaterial(class_6880<class_1959> biome) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider(biome).map(SurfaceMaterialProvider::getUnderMaterial).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static class_2680 findUnderMaterial(class_5281 world, class_2338 pos) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider((class_5281)world, (class_2338)pos).map(SurfaceMaterialProvider::getUnderMaterial).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static abstract class Config
    implements EndBiomeBuilder.BiomeFactory {
        public static final SurfaceMaterialProvider DEFAULT_MATERIAL = new DefaultSurfaceMaterialProvider();
        protected static final class_6686.class_6708 END_STONE = class_6686.method_39047((class_2680)DefaultSurfaceMaterialProvider.END_STONE);
        protected static final class_6686.class_6708 END_MOSS = class_6686.method_39047((class_2680)EndBlocks.END_MOSS.method_9564());
        protected static final class_6686.class_6708 ENDSTONE_DUST = class_6686.method_39047((class_2680)EndBlocks.ENDSTONE_DUST.method_9564());
        protected static final class_6686.class_6708 END_MYCELIUM = class_6686.method_39047((class_2680)EndBlocks.END_MYCELIUM.method_9564());
        protected static final class_6686.class_6708 FLAVOLITE = class_6686.method_39047((class_2680)EndBlocks.FLAVOLITE.stone.method_9564());
        protected static final class_6686.class_6708 SULPHURIC_ROCK = class_6686.method_39047((class_2680)EndBlocks.SULPHURIC_ROCK.stone.method_9564());
        protected static final class_6686.class_6708 BRIMSTONE = class_6686.method_39047((class_2680)EndBlocks.BRIMSTONE.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_FULL = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_FULL.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_HEAVY = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_HEAVY.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_THIN = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_THIN.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_TINY = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_TINY.method_9564());
        protected static final class_6686.class_6708 UMBRALITH = class_6686.method_39047((class_2680)EndBlocks.UMBRALITH.stone.method_9564());

        protected Config() {
        }

        public abstract void addCustomBuildData(EndBiomeBuilder var1);

        public boolean hasCaves() {
            return true;
        }

        public boolean hasReturnGateway() {
            return true;
        }

        public SurfaceMaterialProvider surfaceMaterial() {
            return DEFAULT_MATERIAL;
        }

        @Override
        @NotNull
        public EndBiome instantiateBiome(float fogDensity, BiomeKey<?> key, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable class_5321<class_1959> edge, @Nullable class_5321<class_1959> parent, boolean hasCave, SurfaceMaterialProvider surface) {
            return new EndBiome(fogDensity, (class_5321<class_1959>)key.key, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCave, surface);
        }
    }

    public static class DefaultSurfaceMaterialProvider
    implements SurfaceMaterialProvider {
        public static final class_2680 END_STONE = class_2246.field_10471.method_9564();

        public class_2680 getTopMaterial() {
            return this.getUnderMaterial();
        }

        public class_2680 getAltTopMaterial() {
            return this.getTopMaterial();
        }

        public class_2680 getUnderMaterial() {
            return END_STONE;
        }

        public boolean generateFloorRule() {
            return true;
        }

        public SurfaceRuleBuilder surface() {
            SurfaceRuleBuilder builder = SurfaceRuleBuilder.start();
            if (this.generateFloorRule() && this.getTopMaterial() != this.getUnderMaterial()) {
                if (this.getTopMaterial() != this.getAltTopMaterial()) {
                    builder.floor(this.getTopMaterial());
                } else {
                    builder.chancedFloor(this.getTopMaterial(), this.getAltTopMaterial());
                }
            }
            return (SurfaceRuleBuilder)builder.filler(this.getUnderMaterial());
        }
    }
}

