/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.entity.v1;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class GenericExplosionHelper {
    private GenericExplosionHelper() {
    }

    public static <T extends class_1927> T explode(ExplosionFactory<T> factory, class_1937 level, @Nullable class_1297 source, double x, double y, double z, float radius, class_1937.class_7867 explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, class_1927.method_55108((class_1937)level, (class_1297)source), null, x, y, z, radius, false, explosionInteraction, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880<class_3414>)class_3417.field_15152);
    }

    public static <T extends class_1927> T explode(ExplosionFactory<T> factory, class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction, class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, class_6880<class_3414> explosionSound) {
        T explosion = GenericExplosionHelper.explode(factory, level, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, level.field_9236, smallExplosionParticles, largeExplosionParticles, explosionSound);
        if (!level.field_9236) {
            if (!explosion.method_46667()) {
                explosion.method_8352();
            }
            for (class_3222 serverplayer : ((class_3218)level).method_18456()) {
                if (!(serverplayer.method_5649(x, y, z) < 4096.0)) continue;
                serverplayer.field_13987.method_14364((class_2596)new class_2664(x, y, z, radius, explosion.method_8346(), (class_243)explosion.method_8351().get(serverplayer), explosion.method_55111(), explosion.method_55112(), explosion.method_55113(), explosion.method_55114()));
            }
        }
        return explosion;
    }

    private static <T extends class_1927> T explode(ExplosionFactory<T> factory, class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction, boolean spawnParticles, class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, class_6880<class_3414> explosionSound) {
        T explosion = factory.create(level, source, damageSource, damageCalculator, x, y, z, radius, fire, GenericExplosionHelper.getBlockInteraction(level, source, explosionInteraction), smallExplosionParticles, largeExplosionParticles, explosionSound);
        if (CommonAbstractions.INSTANCE.onExplosionStart(level, (class_1927)explosion)) {
            return explosion;
        }
        explosion.method_8348();
        explosion.method_8350(spawnParticles);
        return explosion;
    }

    private static class_1927.class_4179 getBlockInteraction(class_1937 level, @Nullable class_1297 source, class_1937.class_7867 explosionInteraction) {
        return switch (explosionInteraction) {
            default -> throw new MatchException(null, null);
            case class_1937.class_7867.field_40888 -> class_1927.class_4179.field_40878;
            case class_1937.class_7867.field_40889 -> GenericExplosionHelper.getDestroyType(level.method_8450(), (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40880);
            case class_1937.class_7867.field_40890 -> {
                if (CommonAbstractions.INSTANCE.getMobGriefingRule(level, source)) {
                    yield GenericExplosionHelper.getDestroyType(level.method_8450(), (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40881);
                }
                yield class_1927.class_4179.field_40878;
            }
            case class_1937.class_7867.field_40891 -> GenericExplosionHelper.getDestroyType(level.method_8450(), (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40882);
            case class_1937.class_7867.field_51779 -> class_1927.class_4179.field_47331;
        };
    }

    private static class_1927.class_4179 getDestroyType(class_1928 gameRules, class_1928.class_4313<class_1928.class_4310> gameRule) {
        return gameRules.method_8355(gameRule) ? class_1927.class_4179.field_40879 : class_1927.class_4179.field_18687;
    }

    public static <T extends class_1927> T explode(ExplosionFactory<T> factory, class_1937 level, @Nullable class_1297 source, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, class_1927.method_55108((class_1937)level, (class_1297)source), null, x, y, z, radius, fire, explosionInteraction, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880<class_3414>)class_3417.field_15152);
    }

    public static <T extends class_1927> T explode(ExplosionFactory<T> factory, class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, class_243 pos, float radius, boolean fire, class_1937.class_7867 explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, damageSource, damageCalculator, pos.method_10216(), pos.method_10214(), pos.method_10215(), radius, fire, explosionInteraction, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880<class_3414>)class_3417.field_15152);
    }

    public static <T extends class_1927> T explode(ExplosionFactory<T> factory, class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction) {
        return GenericExplosionHelper.explode(factory, level, source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880<class_3414>)class_3417.field_15152);
    }

    @FunctionalInterface
    public static interface ExplosionFactory<T extends class_1927> {
        public T create(class_1937 var1, @Nullable class_1297 var2, @Nullable class_1282 var3, @Nullable class_5362 var4, double var5, double var7, double var9, float var11, boolean var12, class_1927.class_4179 var13, class_2394 var14, class_2394 var15, class_6880<class_3414> var16);
    }
}

