/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2.tags;

import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import fuzs.puzzleslib.impl.core.CommonFactories;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTagProvider<T>
extends class_2474<T> {
    protected final String modId;
    @Nullable
    private final class_2378<T> registry;
    @Nullable
    private final Function<T, class_5321<T>> keyExtractor;

    public AbstractTagProvider(class_5321<? extends class_2378<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getModId(), context.getPackOutput(), context.getRegistries());
    }

    public AbstractTagProvider(class_5321<? extends class_2378<T>> registryKey, String modId, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
        super(packOutput, registryKey, registries);
        this.modId = modId;
        this.registry = RegistryHelper.findNullableBuiltInRegistry(registryKey);
        this.keyExtractor = this.registry != null ? t -> RegistryHelper.getResourceKeyOrThrow(this.registry, t) : null;
    }

    public abstract void method_10514(class_7225.class_7874 var1);

    @Deprecated
    public class_2474.class_5124<T> method_10512(class_6862<T> tagKey) {
        throw new UnsupportedOperationException();
    }

    public AbstractTagAppender<T> add(String string) {
        return this.add(class_2960.method_60654((String)string));
    }

    public AbstractTagAppender<T> add(class_2960 resourceLocation) {
        return this.add(class_6862.method_40092((class_5321)this.field_40957, (class_2960)resourceLocation));
    }

    public AbstractTagAppender<T> add(class_6862<T> tagKey) {
        return CommonFactories.INSTANCE.getTagAppender(this.method_27169(tagKey), this.keyExtractor);
    }

    protected class_2378<T> registry() {
        Objects.requireNonNull(this.registry, "registry is null");
        return this.registry;
    }

    protected Function<T, class_5321<T>> keyExtractor() {
        Objects.requireNonNull(this.keyExtractor, "key extractor is null");
        return this.keyExtractor;
    }
}

