/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9279;
import net.minecraft.class_9695;
import org.betterx.bclib.util.BCLDataComponents;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;
import org.jetbrains.annotations.NotNull;

public abstract class BCLBaseRecipeBuilder<I extends BaseRecipeBuilder<I>, R extends class_1860<? extends class_9695>>
extends BaseRecipeBuilderImpl<I> {
    protected final class_161.class_162 advancement = class_161.class_162.method_707();
    protected class_1856 primaryInput;
    protected class_1856 secondaryInput;
    protected RecipeOutputConsumer outputTagConsumer;
    private final boolean dualInput;

    protected BCLBaseRecipeBuilder(@NotNull class_2960 id, @NotNull class_1935 output, boolean dualInput) {
        this(id, new class_1799(output, 1), dualInput);
    }

    protected BCLBaseRecipeBuilder(@NotNull class_2960 id, @NotNull class_1799 output, boolean dualInput) {
        super(id, output);
        this.dualInput = dualInput;
        this.group("");
    }

    protected void validate() {
        super.validate();
        if (this.primaryInput == null || this.primaryInput.method_8103()) {
            this.throwIllegalStateException("Primary input for Recipe can't be 'null', recipe {} will be ignored!");
        }
        if (this.secondaryInput == null && this.dualInput) {
            this.throwIllegalStateException("Secondary input for Recipe can't be 'null', recipe {} will be ignored!");
        }
    }

    public final void build(class_8790 ctx) {
        this.validate();
        this.setupAdvancementForResult();
        class_8779 advancementHolder = this.advancement.method_695(this.createAdvancementId());
        if (this.outputTagConsumer != null) {
            class_9279.method_57452(BCLDataComponents.ANVIL_ENTITY_DATA, (class_1799)this.output, (Consumer)this.outputTagConsumer);
        }
        R recipe = this.createRecipe(this.id);
        ctx.method_53819(this.id, recipe, advancementHolder);
    }

    protected abstract R createRecipe(class_2960 var1);

    protected void setupAdvancementForResult() {
        this.advancement.method_708(class_5797.field_39377).method_705("has_the_recipe", class_2119.method_27847((class_2960)this.id)).method_703(class_170.class_171.method_753((class_2960)this.id)).method_704(class_8782.class_8797.field_1257);
    }

    protected class_2960 createAdvancementId() {
        return this.id.method_45138("recipes/" + this.category.method_46203() + "/");
    }

    public I setPrimaryInput(class_1935 ... inputs) {
        this.primaryInput = class_1856.method_8091((class_1935[])inputs);
        return (I)((Object)this);
    }

    public I setPrimaryInput(class_6862<class_1792> input) {
        this.primaryInput = class_1856.method_8106(input);
        return (I)((Object)this);
    }

    public I setPrimaryInputAndUnlock(class_6862<class_1792> input) {
        this.setPrimaryInput(input);
        this.unlockedBy(input);
        return (I)((Object)this);
    }

    public I setPrimaryInputAndUnlock(class_1935 ... inputs) {
        this.setPrimaryInput(inputs);
        for (class_1935 item : inputs) {
            this.unlockedBy(item);
        }
        return (I)((Object)this);
    }

    public I setSecondaryInput(class_1935 ... inputs) {
        this.secondaryInput = class_1856.method_8091((class_1935[])inputs);
        return (I)((Object)this);
    }

    public I setSecondaryInput(class_6862<class_1792> input) {
        this.secondaryInput = class_1856.method_8106(input);
        return (I)((Object)this);
    }

    public I setSecondaryInputAndUnlock(class_6862<class_1792> input) {
        this.setSecondaryInput(input);
        this.unlockedBy(input);
        return (I)((Object)this);
    }

    public I setSecondaryInputAndUnlock(class_1935 ... inputs) {
        this.setSecondaryInput(inputs);
        for (class_1935 item : inputs) {
            this.unlockedBy(item);
        }
        return (I)((Object)this);
    }

    public I setOutputTag(class_2487 tag) {
        this.outputTagConsumer = itemTag -> {
            for (String k : tag.method_10541()) {
                itemTag.method_10566(k, tag.method_10580(k));
            }
        };
        return (I)((Object)this);
    }

    public I setOutputTag(RecipeOutputConsumer consumer) {
        this.outputTagConsumer = consumer;
        return (I)((Object)this);
    }

    public static interface RecipeOutputConsumer
    extends Consumer<class_2487> {
    }
}

